/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.api.IMetadataEntity;

public class Function
implements IMetadataEntity<Function> {
    private static final long serialVersionUID = 1L;
    public static final String LANGUAGE_AQL = "AQL";
    public static final String LANGUAGE_SQLPP = "SQLPP";
    public static final String LANGUAGE_JAVA = "JAVA";
    public static final String RETURNTYPE_VOID = "VOID";
    public static final String NOT_APPLICABLE = "N/A";
    private final FunctionSignature signature;
    private final List<List<List<String>>> dependencies;
    private final List<String> arguments;
    private final String body;
    private final String returnType;
    private final String language;
    private final String kind;

    public Function(FunctionSignature signature, List<String> arguments, String returnType, String functionBody, String language, String functionKind, List<List<List<String>>> dependencies) {
        this.signature = signature;
        this.arguments = arguments;
        this.body = functionBody;
        this.returnType = returnType == null ? RETURNTYPE_VOID : returnType;
        this.language = language;
        this.kind = functionKind;
        if (dependencies == null) {
            this.dependencies = new ArrayList<List<List<String>>>();
            this.dependencies.add(new ArrayList());
            this.dependencies.add(new ArrayList());
        } else {
            this.dependencies = dependencies;
        }
    }

    public FunctionSignature getSignature() {
        return this.signature;
    }

    public String getDataverseName() {
        return this.signature.getNamespace();
    }

    public String getName() {
        return this.signature.getName();
    }

    public int getArity() {
        return this.signature.getArity();
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public List<List<List<String>>> getDependencies() {
        return this.dependencies;
    }

    public String getFunctionBody() {
        return this.body;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getKind() {
        return this.kind;
    }

    @Override
    public Function addToCache(MetadataCache cache) {
        return cache.addFunctionIfNotExists(this);
    }

    @Override
    public Function dropFromCache(MetadataCache cache) {
        return cache.dropFunction(this);
    }
}

