/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.parsers;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParser;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;

public class DoubleParserFactory
implements IValueParserFactory {
    public static final IValueParserFactory INSTANCE = new DoubleParserFactory();
    private static final long serialVersionUID = 1L;

    private DoubleParserFactory() {
    }

    @Override
    public IValueParser createValueParser() {
        return new IValueParser(){

            @Override
            public void parse(char[] buffer, int start, int length, DataOutput out) throws HyracksDataException {
                String s = String.valueOf(buffer, start, length);
                try {
                    out.writeDouble(Double.parseDouble(s));
                }
                catch (NumberFormatException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        };
    }
}

