/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.transaction;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.asterix.common.context.ITransactionOperationTracker;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.common.IModificationOperationCallback;

public abstract class AbstractTransactionContext
implements ITransactionContext {
    protected final TxnId txnId;
    protected final Map<Long, ITransactionOperationTracker> txnOpTrackers;
    private final AtomicLong firstLSN;
    private final AtomicLong lastLSN;
    private final AtomicInteger txnState;
    private final AtomicBoolean isWriteTxn;
    private boolean isTimeout = false;

    protected AbstractTransactionContext(TxnId txnId) {
        this.txnId = txnId;
        this.firstLSN = new AtomicLong(-1L);
        this.lastLSN = new AtomicLong(-1L);
        this.txnState = new AtomicInteger(0);
        this.isTimeout = false;
        this.isWriteTxn = new AtomicBoolean();
        this.txnOpTrackers = new HashMap<Long, ITransactionOperationTracker>();
    }

    public long getFirstLSN() {
        return this.firstLSN.get();
    }

    public void setLastLSN(long newValue) {
        this.firstLSN.compareAndSet(-1L, newValue);
        this.lastLSN.set(Math.max(this.lastLSN.get(), newValue));
    }

    public void setTxnState(int txnState) {
        this.txnState.set(txnState);
    }

    public int getTxnState() {
        return this.txnState.get();
    }

    public TxnId getTxnId() {
        return this.txnId;
    }

    public synchronized void setTimeout(boolean isTimeout) {
        this.isTimeout = isTimeout;
    }

    public synchronized boolean isTimeout() {
        return this.isTimeout;
    }

    public void setWriteTxn(boolean isWriteTxn) {
        this.isWriteTxn.set(isWriteTxn);
    }

    public boolean isWriteTxn() {
        return this.isWriteTxn.get();
    }

    public long getLastLSN() {
        return this.lastLSN.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        try {
            if (this.isWriteTxn()) {
                this.cleanup();
            }
        }
        finally {
            Map<Long, ITransactionOperationTracker> map = this.txnOpTrackers;
            synchronized (map) {
                this.txnOpTrackers.forEach((resource, opTracker) -> opTracker.afterTransaction(resource.longValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(long resourceId, int partition, ILSMIndex index, IModificationOperationCallback callback, boolean primaryIndex) {
        Map<Long, ITransactionOperationTracker> map = this.txnOpTrackers;
        synchronized (map) {
            if (!this.txnOpTrackers.containsKey(resourceId)) {
                ITransactionOperationTracker txnOpTracker = (ITransactionOperationTracker)index.getOperationTracker();
                this.txnOpTrackers.put(resourceId, txnOpTracker);
                txnOpTracker.beforeTransaction(resourceId);
            }
        }
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n" + this.txnId + "\n");
        sb.append("isWriteTxn: " + this.isWriteTxn + "\n");
        sb.append("firstLSN: " + this.firstLSN.get() + "\n");
        sb.append("lastLSN: " + this.lastLSN.get() + "\n");
        sb.append("TransactionState: " + this.txnState + "\n");
        sb.append("isTimeout: " + this.isTimeout + "\n");
        return sb.toString();
    }

    protected abstract void cleanup();
}

