/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.logging;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.ILogReader;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.asterix.common.transactions.MutableLong;
import org.apache.asterix.common.transactions.TxnLogFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogReader
implements ILogReader {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ILogManager logMgr;
    private final long logFileSize;
    private final int logPageSize;
    private final MutableLong flushLSN;
    private final boolean isRecoveryMode;
    private final ByteBuffer readBuffer;
    private final ILogRecord logRecord;
    private long readLSN;
    private long bufferBeginLSN;
    private long fileBeginLSN;
    private TxnLogFile logFile;

    public LogReader(ILogManager logMgr, long logFileSize, int logPageSize, MutableLong flushLSN, boolean isRecoveryMode) {
        this.logMgr = logMgr;
        this.logFileSize = logFileSize;
        this.logPageSize = logPageSize;
        this.flushLSN = flushLSN;
        this.isRecoveryMode = isRecoveryMode;
        this.readBuffer = ByteBuffer.allocate(logPageSize);
        this.logRecord = new LogRecord();
    }

    public void setPosition(long lsn) {
        this.readLSN = lsn;
        if (this.waitForFlushOrReturnIfEOF() == ReturnState.EOF) {
            return;
        }
        this.getLogFile();
        this.fillLogReadBuffer();
    }

    public ILogRecord next() {
        boolean hasRemaining;
        if (this.waitForFlushOrReturnIfEOF() == ReturnState.EOF) {
            return null;
        }
        if (this.readBuffer.position() == this.readBuffer.limit() && !(hasRemaining = this.refillLogReadBuffer()) && this.isRecoveryMode && this.readLSN < this.flushLSN.get()) {
            LOGGER.error("Transaction log ends before expected. Log files may be missing.");
            return null;
        }
        ByteBuffer readBuffer = this.readBuffer;
        boolean refilled = false;
        block6: while (true) {
            ILogRecord.RecordReadStatus status = this.logRecord.readLogRecord(readBuffer);
            switch (status) {
                case TRUNCATED: {
                    if (!refilled) {
                        if (!this.refillLogReadBuffer()) {
                            return null;
                        }
                        refilled = true;
                        continue block6;
                    }
                    LOGGER.info("Log file has truncated log records.");
                    return null;
                }
                case LARGE_RECORD: {
                    readBuffer = ByteBuffer.allocate(this.logRecord.getLogSize());
                    this.fillLogReadBuffer(this.logRecord.getLogSize(), readBuffer);
                    continue block6;
                }
                case BAD_CHKSUM: {
                    LOGGER.error("Transaction log contains corrupt log records (perhaps due to medium error). Stopping recovery early.");
                    return null;
                }
                case OK: {
                    break block6;
                }
                default: {
                    throw new IllegalStateException("Unexpected log read status: " + status);
                }
            }
            break;
        }
        this.logRecord.setLSN(this.readLSN);
        this.readLSN += (long)this.logRecord.getLogSize();
        return this.logRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReturnState waitForFlushOrReturnIfEOF() {
        MutableLong mutableLong = this.flushLSN;
        synchronized (mutableLong) {
            while (this.readLSN >= this.flushLSN.get()) {
                if (this.isRecoveryMode) {
                    return ReturnState.EOF;
                }
                try {
                    this.flushLSN.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ACIDException((Throwable)e);
                }
            }
            return ReturnState.FLUSH;
        }
    }

    private boolean refillLogReadBuffer() {
        try {
            if (this.readLSN % this.logFileSize == this.logFile.size()) {
                this.readLSN += this.logFileSize - this.readLSN % this.logFileSize;
                this.getLogFile();
            }
            return this.fillLogReadBuffer();
        }
        catch (IOException e) {
            throw new ACIDException((Throwable)e);
        }
    }

    private boolean fillLogReadBuffer() {
        return this.fillLogReadBuffer(this.logPageSize, this.readBuffer);
    }

    private boolean fillLogReadBuffer(int readSize, ByteBuffer readBuffer) {
        int size = 0;
        int read = 0;
        readBuffer.position(0);
        readBuffer.limit(readSize);
        try {
            this.logFile.position(this.readLSN % this.logFileSize);
            while (size < readSize && read != -1) {
                read = this.logFile.read(readBuffer);
                if (read <= 0) continue;
                size += read;
            }
        }
        catch (IOException e) {
            throw new ACIDException((Throwable)e);
        }
        readBuffer.position(0);
        readBuffer.limit(size);
        if (size == 0 && read == -1) {
            return false;
        }
        this.bufferBeginLSN = this.readLSN;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ILogRecord read(long lsn) {
        this.readLSN = lsn;
        MutableLong mutableLong = this.flushLSN;
        synchronized (mutableLong) {
            while (this.readLSN >= this.flushLSN.get()) {
                try {
                    this.flushLSN.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ACIDException((Throwable)e);
                }
            }
        }
        try {
            if (this.logFile == null || this.readLSN < this.fileBeginLSN || this.readLSN >= this.fileBeginLSN + this.logFile.size()) {
                this.getLogFile();
                this.fillLogReadBuffer();
            } else if (this.readLSN < this.bufferBeginLSN || this.readLSN >= this.bufferBeginLSN + (long)this.readBuffer.limit()) {
                this.fillLogReadBuffer();
            } else {
                this.readBuffer.position((int)(this.readLSN - this.bufferBeginLSN));
            }
        }
        catch (IOException e) {
            throw new ACIDException((Throwable)e);
        }
        ByteBuffer readBuffer = this.readBuffer;
        block14: while (true) {
            ILogRecord.RecordReadStatus status = this.logRecord.readLogRecord(readBuffer);
            switch (status) {
                case LARGE_RECORD: {
                    readBuffer = ByteBuffer.allocate(this.logRecord.getLogSize());
                    this.fillLogReadBuffer(this.logRecord.getLogSize(), readBuffer);
                    continue block14;
                }
                case TRUNCATED: {
                    if (!this.fillLogReadBuffer()) throw new IllegalStateException("Could not read LSN(" + lsn + ") from log file id " + this.logFile.getLogFileId());
                    continue block14;
                }
                case BAD_CHKSUM: {
                    throw new ACIDException("Log record has incorrect checksum");
                }
                case OK: {
                    break block14;
                }
                default: {
                    throw new IllegalStateException("Unexpected log read status: " + status);
                }
            }
            break;
        }
        this.logRecord.setLSN(this.readLSN);
        this.readLSN += (long)this.logRecord.getLogSize();
        return this.logRecord;
    }

    private void getLogFile() {
        try {
            this.close();
            this.logFile = this.logMgr.getLogFile(this.readLSN);
            this.fileBeginLSN = this.logFile.getFileBeginLSN();
        }
        catch (IOException e) {
            throw new ACIDException((Throwable)e);
        }
    }

    public void close() {
        try {
            if (this.logFile != null) {
                this.logFile.close();
                this.logFile = null;
            }
        }
        catch (IOException e) {
            throw new ACIDException((Throwable)e);
        }
    }

    private static enum ReturnState {
        FLUSH,
        EOF;

    }
}

