/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.locking;

import org.apache.asterix.transaction.management.service.locking.ResourceGroup;

class ResourceGroupTable {
    public final int size;
    private ResourceGroup[] table;

    public ResourceGroupTable(int size) {
        this.size = size;
        this.table = new ResourceGroup[size];
        for (int i = 0; i < size; ++i) {
            this.table[i] = new ResourceGroup();
        }
    }

    ResourceGroup get(int dId, int entityHashValue) {
        int h = Math.abs(dId ^ entityHashValue);
        if (h < 0) {
            h = 0;
        }
        return this.table[h % this.size];
    }

    ResourceGroup get(int i) {
        return this.table[i];
    }

    public void getAllLatches() {
        for (int i = 0; i < this.size; ++i) {
            this.table[i].getLatch();
        }
    }

    public void releaseAllLatches() {
        for (int i = 0; i < this.size; ++i) {
            this.table[i].releaseLatch();
        }
    }

    public StringBuilder append(StringBuilder sb) {
        return this.append(sb, false);
    }

    public StringBuilder append(StringBuilder sb, boolean detail) {
        for (int i = 0; i < this.table.length; ++i) {
            sb.append(i).append(" : ");
            if (detail) {
                sb.append(this.table[i]);
            } else {
                sb.append(this.table[i].firstResourceIndex);
            }
            sb.append('\n');
        }
        return sb;
    }
}

