/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.locking;

import java.util.ArrayList;
import org.apache.asterix.transaction.management.service.locking.ChildIntArrayManager;

public class PrimitiveIntHashMap {
    private final int CHILD_BUCKETS;
    private final int NUM_OF_SLOTS;
    private final int SHRINK_TIMER_THRESHOLD;
    private int occupiedSlots;
    private ArrayList<ChildIntArrayManager> pArray;
    private int hashMod;
    private long shrinkTimer;
    private boolean isShrinkTimerOn;
    private int iterBucketIndex;
    private int iterSlotIndex;
    private int iterChildIndex;
    private KeyValuePair iterPair;

    public PrimitiveIntHashMap() {
        this.CHILD_BUCKETS = 512;
        this.NUM_OF_SLOTS = 8;
        this.SHRINK_TIMER_THRESHOLD = 120000;
        this.pArray = new ArrayList();
        this.pArray.add(new ChildIntArrayManager(this));
        this.hashMod = this.CHILD_BUCKETS;
        this.occupiedSlots = 0;
        this.iterPair = new KeyValuePair();
    }

    public PrimitiveIntHashMap(int childBuckets, int numOfSlots, int shrinkTimerThreshold) {
        this.CHILD_BUCKETS = childBuckets;
        this.NUM_OF_SLOTS = numOfSlots;
        this.SHRINK_TIMER_THRESHOLD = shrinkTimerThreshold;
        this.pArray = new ArrayList();
        this.pArray.add(new ChildIntArrayManager(this));
        this.hashMod = this.CHILD_BUCKETS;
        this.occupiedSlots = 0;
        this.iterPair = new KeyValuePair();
    }

    public void put(int key, int value) {
        int growCount = 0;
        int bucketNum = this.hash(key);
        ChildIntArrayManager child = this.pArray.get(bucketNum / this.CHILD_BUCKETS);
        while (child.isFull(bucketNum % this.CHILD_BUCKETS)) {
            this.growHashMap();
            bucketNum = this.hash(key);
            child = this.pArray.get(bucketNum / this.CHILD_BUCKETS);
            if (growCount > 2) {
                // empty if block
            }
            ++growCount;
        }
        this.occupiedSlots += child.put(bucketNum % this.CHILD_BUCKETS, key, value, false);
    }

    public void upsert(int key, int value) {
        int growCount = 0;
        int bucketNum = this.hash(key);
        ChildIntArrayManager child = this.pArray.get(bucketNum / this.CHILD_BUCKETS);
        while (child.isFull(bucketNum % this.CHILD_BUCKETS)) {
            this.growHashMap();
            bucketNum = this.hash(key);
            child = this.pArray.get(bucketNum / this.CHILD_BUCKETS);
            if (growCount > 2) {
                // empty if block
            }
            ++growCount;
        }
        this.occupiedSlots += child.put(bucketNum % this.CHILD_BUCKETS, key, value, true);
    }

    private int hash(int key) {
        return key % this.hashMod;
    }

    private void growHashMap() {
        int size = this.pArray.size();
        for (int i = 0; i < size; ++i) {
            this.pArray.add(new ChildIntArrayManager(this));
        }
        this.hashMod *= 2;
        this.rehash(0, size, this.hashMod / 2);
    }

    private void shrinkHashMap() {
        int size = this.pArray.size();
        this.hashMod /= 2;
        this.rehash(size / 2, size, this.hashMod * 2);
        for (int i = size - 1; i >= size / 2; --i) {
            this.pArray.remove(i);
        }
    }

    private void rehash(int begin, int end, int oldHashMod) {
        for (int i = begin; i < end; ++i) {
            ChildIntArrayManager child = this.pArray.get(i);
            for (int j = 0; j < this.CHILD_BUCKETS; ++j) {
                if (child.cArray[j][0] == 0) continue;
                for (int k = 1; k < this.NUM_OF_SLOTS; ++k) {
                    int key = child.cArray[j][k * 2];
                    if (this.hash(key) == key % oldHashMod) continue;
                    int value = child.cArray[j][k * 2 + 1];
                    child.cArray[j][k * 2] = -1;
                    int[] nArray = child.cArray[j];
                    nArray[0] = nArray[0] - 1;
                    this.pArray.get(this.hash(key) / this.CHILD_BUCKETS).put(this.hash(key) % this.CHILD_BUCKETS, key, value, false);
                }
            }
        }
    }

    public int get(int key) {
        int bucketNum = this.hash(key);
        return this.pArray.get(bucketNum / this.CHILD_BUCKETS).get(bucketNum % this.CHILD_BUCKETS, key);
    }

    public void remove(int key) {
        int bucketNum = this.hash(key);
        this.occupiedSlots -= this.pArray.get(bucketNum / this.CHILD_BUCKETS).remove(bucketNum % this.CHILD_BUCKETS, key);
        if (this.needShrink()) {
            this.shrinkHashMap();
        }
    }

    private boolean needShrink() {
        int size = this.pArray.size();
        int usedSlots = this.occupiedSlots;
        if (usedSlots == 0) {
            usedSlots = 1;
        }
        if (size > 1 && size * this.CHILD_BUCKETS * this.NUM_OF_SLOTS / usedSlots >= 3 && this.isSafeToShrink()) {
            if (this.isShrinkTimerOn) {
                if (System.currentTimeMillis() - this.shrinkTimer >= (long)this.SHRINK_TIMER_THRESHOLD) {
                    this.isShrinkTimerOn = false;
                    return true;
                }
            } else {
                this.isShrinkTimerOn = true;
                this.shrinkTimer = System.currentTimeMillis();
            }
        } else {
            this.isShrinkTimerOn = false;
        }
        return false;
    }

    private boolean isSafeToShrink() {
        int size = this.pArray.size();
        for (int i = 0; i < size / 2; ++i) {
            ChildIntArrayManager HChild = this.pArray.get(i);
            ChildIntArrayManager TChild = this.pArray.get(size / 2 + i);
            for (int j = 0; j < this.CHILD_BUCKETS; ++j) {
                if (HChild.cArray[j][0] + TChild.cArray[j][0] <= this.NUM_OF_SLOTS - 1) continue;
                return false;
            }
        }
        return true;
    }

    public String prettyPrint() {
        StringBuilder s = new StringBuilder("\n########### PrimitiveIntHashMap Status #############\n");
        int size = this.pArray.size();
        for (int i = 0; i < size; ++i) {
            ChildIntArrayManager child = this.pArray.get(i);
            s.append("child[").append(i).append("]\n");
            for (int j = 0; j < this.CHILD_BUCKETS; ++j) {
                s.append(j).append(" ");
                for (int k = 0; k < this.NUM_OF_SLOTS; ++k) {
                    s.append("[").append(child.cArray[j][k * 2]).append(",").append(child.cArray[j][k * 2 + 1]).append("] ");
                }
                s.append("\n");
            }
        }
        return s.toString();
    }

    public int getNumOfSlots() {
        return this.NUM_OF_SLOTS;
    }

    public int getNumOfChildBuckets() {
        return this.CHILD_BUCKETS;
    }

    public void clear(boolean needShrink) {
        int size = this.pArray.size();
        for (int i = size - 1; i >= 0; --i) {
            if (needShrink && i != 0) {
                this.pArray.remove(i);
                continue;
            }
            this.pArray.get(i).clear();
        }
        this.occupiedSlots = 0;
    }

    public void beginIterate() {
        this.iterChildIndex = 0;
        this.iterBucketIndex = 0;
        this.iterSlotIndex = 1;
    }

    public KeyValuePair getNextKeyValue() {
        while (this.iterChildIndex < this.pArray.size()) {
            while (this.iterBucketIndex < this.CHILD_BUCKETS) {
                if (this.iterSlotIndex != 1 || this.pArray.get((int)this.iterChildIndex).cArray[this.iterBucketIndex][0] != 0) {
                    while (this.iterSlotIndex < this.NUM_OF_SLOTS) {
                        this.iterPair.key = this.pArray.get((int)this.iterChildIndex).cArray[this.iterBucketIndex][this.iterSlotIndex * 2];
                        if (this.iterPair.key != -1) {
                            this.iterPair.value = this.pArray.get((int)this.iterChildIndex).cArray[this.iterBucketIndex][this.iterSlotIndex * 2 + 1];
                            ++this.iterSlotIndex;
                            return this.iterPair;
                        }
                        ++this.iterSlotIndex;
                    }
                }
                ++this.iterBucketIndex;
                this.iterSlotIndex = 1;
            }
            ++this.iterChildIndex;
            this.iterBucketIndex = 0;
        }
        return null;
    }

    public int getNextKey() {
        while (this.iterChildIndex < this.pArray.size()) {
            while (this.iterBucketIndex < this.CHILD_BUCKETS) {
                if (this.iterSlotIndex != 1 || this.pArray.get((int)this.iterChildIndex).cArray[this.iterBucketIndex][0] != 0) {
                    while (this.iterSlotIndex < this.NUM_OF_SLOTS) {
                        this.iterPair.key = this.pArray.get((int)this.iterChildIndex).cArray[this.iterBucketIndex][this.iterSlotIndex * 2];
                        if (this.iterPair.key != -1) {
                            ++this.iterSlotIndex;
                            return this.iterPair.key;
                        }
                        ++this.iterSlotIndex;
                    }
                }
                ++this.iterBucketIndex;
                this.iterSlotIndex = 1;
            }
            ++this.iterChildIndex;
            this.iterBucketIndex = 0;
        }
        return -1;
    }

    public int getNextValue() {
        while (this.iterChildIndex < this.pArray.size()) {
            while (this.iterBucketIndex < this.CHILD_BUCKETS) {
                if (this.iterSlotIndex != 1 || this.pArray.get((int)this.iterChildIndex).cArray[this.iterBucketIndex][0] != 0) {
                    while (this.iterSlotIndex < this.NUM_OF_SLOTS) {
                        this.iterPair.key = this.pArray.get((int)this.iterChildIndex).cArray[this.iterBucketIndex][this.iterSlotIndex * 2];
                        if (this.iterPair.key != -1) {
                            this.iterPair.value = this.pArray.get((int)this.iterChildIndex).cArray[this.iterBucketIndex][this.iterSlotIndex * 2 + 1];
                            ++this.iterSlotIndex;
                            return this.iterPair.value;
                        }
                        ++this.iterSlotIndex;
                    }
                }
                ++this.iterBucketIndex;
                this.iterSlotIndex = 1;
            }
            ++this.iterChildIndex;
            this.iterBucketIndex = 0;
        }
        return -1;
    }

    public static class KeyValuePair {
        public int key;
        public int value;
    }
}

