/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.locking;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.asterix.transaction.management.service.locking.JobArenaManager;
import org.apache.asterix.transaction.management.service.locking.RequestArenaManager;
import org.apache.asterix.transaction.management.service.locking.ResourceArenaManager;
import org.apache.asterix.transaction.management.service.locking.ResourceGroupTable;
import org.apache.asterix.transaction.management.service.locking.TablePrinter;
import org.apache.asterix.transaction.management.service.locking.TypeUtil;

public class DumpTablePrinter
implements TablePrinter {
    private ResourceGroupTable table;
    private ResourceArenaManager resArenaMgr;
    private RequestArenaManager reqArenaMgr;
    private JobArenaManager jobArenaMgr;
    private ConcurrentHashMap<Long, Long> txnIdToJobSlotMap;

    DumpTablePrinter(ResourceGroupTable table, ResourceArenaManager resArenaMgr, RequestArenaManager reqArenaMgr, JobArenaManager jobArenaMgr, ConcurrentHashMap<Long, Long> txnIdToJobSlotMap) {
        this.table = table;
        this.resArenaMgr = resArenaMgr;
        this.reqArenaMgr = reqArenaMgr;
        this.jobArenaMgr = jobArenaMgr;
        this.txnIdToJobSlotMap = txnIdToJobSlotMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuilder append(StringBuilder sb) {
        this.table.getAllLatches();
        try {
            sb.append(">>dump_begin\t>>----- [resTable] -----\n");
            this.table.append(sb);
            sb.append(">>dump_end\t>>----- [resTable] -----\n");
            sb.append(">>dump_begin\t>>----- [resArenaMgr] -----\n");
            this.resArenaMgr.append(sb);
            sb.append(">>dump_end\t>>----- [resArenaMgr] -----\n");
            sb.append(">>dump_begin\t>>----- [reqArenaMgr] -----\n");
            this.reqArenaMgr.append(sb);
            sb.append(">>dump_end\t>>----- [reqArenaMgr] -----\n");
            sb.append(">>dump_begin\t>>----- [txnIdSlotMap] -----\n");
            for (Long i : this.txnIdToJobSlotMap.keySet()) {
                sb.append(i).append(" : ");
                TypeUtil.Global.append(sb, this.txnIdToJobSlotMap.get(i));
                sb.append("\n");
            }
            sb.append(">>dump_end\t>>----- [jobIdSlotMap] -----\n");
            sb.append(">>dump_begin\t>>----- [jobArenaMgr] -----\n");
            this.jobArenaMgr.append(sb);
            sb.append(">>dump_end\t>>----- [jobArenaMgr] -----\n");
        }
        finally {
            this.table.releaseAllLatches();
        }
        return sb;
    }

    String resQueueToString(long resSlot) {
        return this.appendResQueue(new StringBuilder(), resSlot).toString();
    }

    StringBuilder appendResQueue(StringBuilder sb, long resSlot) {
        this.resArenaMgr.appendRecord(sb, resSlot);
        sb.append("\n");
        this.appendReqQueue(sb, this.resArenaMgr.getLastHolder(resSlot));
        return sb;
    }

    StringBuilder appendReqQueue(StringBuilder sb, long head) {
        while (head != -1L) {
            this.reqArenaMgr.appendRecord(sb, head);
            sb.append("\n");
            head = this.reqArenaMgr.getNextRequest(head);
        }
        return sb;
    }
}

