/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators;

import java.nio.ByteBuffer;
import org.apache.asterix.runtime.operators.AbstractLSMSecondaryIndexCreationNodePushable;
import org.apache.asterix.runtime.operators.LSMSecondaryIndexCreationTupleProcessorNodePushable;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.tuples.PermutingFrameTupleReference;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.util.LSMComponentIdUtils;

public class LSMSecondaryIndexBulkLoadNodePushable
extends AbstractLSMSecondaryIndexCreationNodePushable {
    private final PermutingFrameTupleReference tuple;
    private final PermutingTupleReference sourceTuple;
    private final PermutingTupleReference deletedKeyTuple;
    private final IIndexDataflowHelper primaryIndexHelper;
    private final IIndexDataflowHelper secondaryIndexHelper;
    private ILSMIndex primaryIndex;
    private ILSMIndex secondaryIndex;
    private LSMIndexDiskComponentBulkLoader componentBulkLoader;
    private int currentComponentPos = -1;

    public LSMSecondaryIndexBulkLoadNodePushable(IHyracksTaskContext ctx, int partition, RecordDescriptor inputRecDesc, IIndexDataflowHelperFactory primaryIndexHelperFactory, IIndexDataflowHelperFactory secondaryIndexHelperFactory, int[] fieldPermutation, int numTagFields, int numSecondaryKeys, int numPrimaryKeys, boolean hasBuddyBTree) throws HyracksDataException {
        super(ctx, partition, inputRecDesc, numTagFields, numSecondaryKeys, numPrimaryKeys, hasBuddyBTree);
        this.primaryIndexHelper = primaryIndexHelperFactory.create(ctx.getJobletContext().getServiceContext(), partition);
        this.secondaryIndexHelper = secondaryIndexHelperFactory.create(ctx.getJobletContext().getServiceContext(), partition);
        this.tuple = new PermutingFrameTupleReference(fieldPermutation);
        int[] sourcePermutation = new int[fieldPermutation.length - numTagFields];
        for (int i = 0; i < sourcePermutation.length; ++i) {
            sourcePermutation[i] = i + numTagFields;
        }
        this.sourceTuple = new PermutingTupleReference(sourcePermutation);
        int[] deletedKeyPermutation = new int[inputRecDesc.getFieldCount() - numTagFields - numSecondaryKeys];
        for (int i = 0; i < deletedKeyPermutation.length; ++i) {
            deletedKeyPermutation[i] = i + numTagFields + numSecondaryKeys;
        }
        this.deletedKeyTuple = new PermutingTupleReference(deletedKeyPermutation);
    }

    @Override
    public void open() throws HyracksDataException {
        super.open();
        this.primaryIndexHelper.open();
        this.primaryIndex = (ILSMIndex)this.primaryIndexHelper.getIndexInstance();
        this.secondaryIndexHelper.open();
        this.secondaryIndex = (ILSMIndex)this.secondaryIndexHelper.getIndexInstance();
    }

    public void close() throws HyracksDataException {
        HyracksDataException closeException = null;
        try {
            this.endCurrentComponent();
        }
        catch (HyracksDataException e) {
            closeException = e;
        }
        try {
            if (this.primaryIndexHelper != null) {
                this.primaryIndexHelper.close();
            }
        }
        catch (HyracksDataException e) {
            if (closeException == null) {
                closeException = e;
            }
            closeException.addSuppressed((Throwable)e);
        }
        try {
            if (this.secondaryIndexHelper != null) {
                this.secondaryIndexHelper.close();
            }
        }
        catch (HyracksDataException e) {
            if (closeException == null) {
                closeException = e;
            }
            closeException.addSuppressed((Throwable)e);
        }
        try {
            this.writer.close();
        }
        catch (HyracksDataException th) {
            if (closeException == null) {
                closeException = th;
            }
            closeException.addSuppressed((Throwable)th);
        }
        if (closeException != null) {
            throw closeException;
        }
    }

    public void flush() throws HyracksDataException {
        this.writer.flush();
    }

    @Override
    public void fail() throws HyracksDataException {
        this.writer.fail();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            try {
                this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
                int componentPos = this.getComponentPos((ITupleReference)this.tuple);
                if (componentPos != this.currentComponentPos) {
                    this.loadNewComponent(componentPos);
                    this.currentComponentPos = componentPos;
                }
                if (this.isAntiMatterTuple((ITupleReference)this.tuple)) {
                    this.addAntiMatterTuple((ITupleReference)this.tuple);
                    continue;
                }
                this.addMatterTuple((ITupleReference)this.tuple);
                continue;
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    private void endCurrentComponent() throws HyracksDataException {
        if (this.componentBulkLoader != null) {
            this.componentBulkLoader.end();
            this.componentBulkLoader = null;
        }
    }

    private void loadNewComponent(int componentPos) throws HyracksDataException {
        this.endCurrentComponent();
        int numTuples = this.getNumDeletedTuples(componentPos);
        ILSMDiskComponent primaryComponent = (ILSMDiskComponent)this.primaryIndex.getDiskComponents().get(componentPos);
        this.componentBulkLoader = (LSMIndexDiskComponentBulkLoader)this.secondaryIndex.createBulkLoader(1.0f, false, (long)numTuples, false);
        ILSMDiskComponent diskComponent = this.componentBulkLoader.getComponent();
        LSMComponentIdUtils.persist((ILSMComponentId)primaryComponent.getId(), (IComponentMetadata)diskComponent.getMetadata());
    }

    private void addAntiMatterTuple(ITupleReference tuple) throws HyracksDataException {
        if (this.hasBuddyBTree) {
            this.deletedKeyTuple.reset(tuple);
            this.componentBulkLoader.delete((ITupleReference)this.deletedKeyTuple);
        } else {
            this.sourceTuple.reset(tuple);
            this.componentBulkLoader.delete((ITupleReference)this.sourceTuple);
        }
    }

    private void addMatterTuple(ITupleReference tuple) throws HyracksDataException {
        this.sourceTuple.reset(tuple);
        this.componentBulkLoader.add((ITupleReference)this.sourceTuple);
    }

    private int getNumDeletedTuples(int componentPos) {
        LSMSecondaryIndexCreationTupleProcessorNodePushable.DeletedTupleCounter counter = (LSMSecondaryIndexCreationTupleProcessorNodePushable.DeletedTupleCounter)this.ctx.getStateObject((Object)this.partition);
        return counter.get(componentPos);
    }
}

