/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.message;

import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.transactions.IResourceIdManager;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReportLocalCountersMessage
implements ICcAddressedMessage {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private final long maxResourceId;
    private final long maxTxnId;
    private final long maxJobId;
    private final String src;

    public ReportLocalCountersMessage(String src, long maxResourceId, long maxTxnId, long maxJobId) {
        this.src = src;
        this.maxResourceId = maxResourceId;
        this.maxTxnId = maxTxnId;
        this.maxJobId = maxJobId;
    }

    public void handle(ICcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        IResourceIdManager resourceIdManager = appCtx.getResourceIdManager();
        try {
            appCtx.getTxnIdFactory().ensureMinimumId(this.maxTxnId);
        }
        catch (AlgebricksException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        resourceIdManager.report(this.src, this.maxResourceId);
        ((ClusterControllerService)appCtx.getServiceContext().getControllerService()).getJobIdFactory().setMaxJobId(this.maxJobId);
    }

    public static void send(CcId ccId, NodeControllerService ncs) throws HyracksDataException {
        INcApplicationContext appContext = (INcApplicationContext)ncs.getApplicationContext();
        long maxResourceId = Math.max(appContext.getLocalResourceRepository().maxId(), 100L);
        long maxTxnId = appContext.getMaxTxnId();
        long maxJobId = ncs.getMaxJobId(ccId);
        ReportLocalCountersMessage countersMessage = new ReportLocalCountersMessage(ncs.getId(), maxResourceId, maxTxnId, maxJobId);
        try {
            ((INCMessageBroker)ncs.getContext().getMessageBroker()).sendMessageToCC(ccId, (ICcAddressedMessage)countersMessage);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Unable to report local counters", (Throwable)e);
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public String toString() {
        return ReportLocalCountersMessage.class.getSimpleName();
    }
}

