/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.job.resource;

import java.io.Serializable;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.resource.IClusterCapacity;
import org.apache.hyracks.api.job.resource.IJobCapacityController;
import org.apache.hyracks.api.job.resource.IReadOnlyClusterCapacity;
import org.apache.hyracks.control.cc.scheduler.IResourceManager;

public class JobCapacityController
implements IJobCapacityController {
    private final IResourceManager resourceManager;

    public JobCapacityController(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public IJobCapacityController.JobSubmissionStatus allocate(JobSpecification job) throws HyracksException {
        IClusterCapacity requiredCapacity = job.getRequiredClusterCapacity();
        long reqAggregatedMemoryByteSize = requiredCapacity.getAggregatedMemoryByteSize();
        int reqAggregatedNumCores = requiredCapacity.getAggregatedCores();
        IReadOnlyClusterCapacity maximumCapacity = this.resourceManager.getMaximumCapacity();
        if (reqAggregatedMemoryByteSize > maximumCapacity.getAggregatedMemoryByteSize() || reqAggregatedNumCores > maximumCapacity.getAggregatedCores()) {
            throw HyracksException.create((int)9, (Serializable[])new Serializable[]{requiredCapacity.toString(), maximumCapacity.toString()});
        }
        IClusterCapacity currentCapacity = this.resourceManager.getCurrentCapacity();
        long currentAggregatedMemoryByteSize = currentCapacity.getAggregatedMemoryByteSize();
        int currentAggregatedAvailableCores = currentCapacity.getAggregatedCores();
        if (reqAggregatedMemoryByteSize > currentAggregatedMemoryByteSize || reqAggregatedNumCores > currentAggregatedAvailableCores) {
            return IJobCapacityController.JobSubmissionStatus.QUEUE;
        }
        currentCapacity.setAggregatedMemoryByteSize(currentAggregatedMemoryByteSize - reqAggregatedMemoryByteSize);
        currentCapacity.setAggregatedCores(currentAggregatedAvailableCores - reqAggregatedNumCores);
        return IJobCapacityController.JobSubmissionStatus.EXECUTE;
    }

    public void release(JobSpecification job) {
        IClusterCapacity requiredCapacity = job.getRequiredClusterCapacity();
        long reqAggregatedMemoryByteSize = requiredCapacity.getAggregatedMemoryByteSize();
        int reqAggregatedNumCores = requiredCapacity.getAggregatedCores();
        IClusterCapacity currentCapacity = this.resourceManager.getCurrentCapacity();
        long aggregatedMemoryByteSize = currentCapacity.getAggregatedMemoryByteSize();
        int aggregatedNumCores = currentCapacity.getAggregatedCores();
        currentCapacity.setAggregatedMemoryByteSize(aggregatedMemoryByteSize + reqAggregatedMemoryByteSize);
        currentCapacity.setAggregatedCores(aggregatedNumCores + reqAggregatedNumCores);
    }
}

