/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.functions;

import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionManager;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.runtime.functions.FunctionCollection;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;

public final class FunctionManager
implements IFunctionManager {
    private final Map<Pair<FunctionIdentifier, Integer>, IFunctionDescriptorFactory> functions;
    private final Map<FunctionIdentifier, IFunctionTypeInferer> typeInferers;

    public FunctionManager(FunctionCollection functionCollection) {
        HashMap<Pair<FunctionIdentifier, Integer>, IFunctionDescriptorFactory> functionsMap = new HashMap<Pair<FunctionIdentifier, Integer>, IFunctionDescriptorFactory>();
        HashMap<FunctionIdentifier, IFunctionTypeInferer> typeInferersMap = new HashMap<FunctionIdentifier, IFunctionTypeInferer>();
        for (IFunctionDescriptorFactory descriptorFactory : functionCollection.getFunctionDescriptorFactories()) {
            FunctionIdentifier fid = descriptorFactory.createFunctionDescriptor().getIdentifier();
            functionsMap.put((Pair<FunctionIdentifier, Integer>)new Pair((Object)fid, (Object)fid.getArity()), descriptorFactory);
            IFunctionTypeInferer typeInferer = descriptorFactory.createFunctionTypeInferer();
            if (typeInferer == null) continue;
            typeInferersMap.put(fid, typeInferer);
        }
        this.functions = functionsMap;
        this.typeInferers = typeInferersMap;
    }

    public IFunctionDescriptor lookupFunction(FunctionIdentifier fid) throws AlgebricksException {
        Pair key = new Pair((Object)fid, (Object)fid.getArity());
        IFunctionDescriptorFactory factory = this.functions.get(key);
        if (factory == null) {
            throw new AlgebricksException("Inappropriate use of function '" + fid.getName() + "'");
        }
        return factory.createFunctionDescriptor();
    }

    public IFunctionTypeInferer lookupFunctionTypeInferer(FunctionIdentifier fid) {
        return this.typeInferers.get(fid);
    }
}

