/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ARecordSerializerDeserializer;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.runtime.RuntimeRecordTypeInfo;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class GetRecordFieldValueEvalFactory
implements IScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private IScalarEvaluatorFactory recordEvalFactory;
    private IScalarEvaluatorFactory fldNameEvalFactory;
    private final ARecordType recordType;

    public GetRecordFieldValueEvalFactory(IScalarEvaluatorFactory recordEvalFactory, IScalarEvaluatorFactory fldNameEvalFactory, ARecordType recordType) {
        this.recordEvalFactory = recordEvalFactory;
        this.fldNameEvalFactory = fldNameEvalFactory;
        this.recordType = recordType;
    }

    public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
        return new IScalarEvaluator(){
            private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
            private final DataOutput out = this.resultStorage.getDataOutput();
            private final IPointable inputArg0 = new VoidPointable();
            private final IPointable inputArg1 = new VoidPointable();
            private final IScalarEvaluator recordEval = GetRecordFieldValueEvalFactory.access$000(GetRecordFieldValueEvalFactory.this).createScalarEvaluator(ctx);
            private final IScalarEvaluator fieldNameEval = GetRecordFieldValueEvalFactory.access$100(GetRecordFieldValueEvalFactory.this).createScalarEvaluator(ctx);
            private final RuntimeRecordTypeInfo recTypeInfo = new RuntimeRecordTypeInfo();
            {
                this.recTypeInfo.reset(GetRecordFieldValueEvalFactory.this.recordType);
            }

            public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                try {
                    this.resultStorage.reset();
                    this.fieldNameEval.evaluate(tuple, this.inputArg1);
                    byte[] serFldName = this.inputArg1.getByteArray();
                    int serFldNameOffset = this.inputArg1.getStartOffset();
                    int serFldNameLen = this.inputArg1.getLength();
                    this.recordEval.evaluate(tuple, this.inputArg0);
                    byte[] serRecord = this.inputArg0.getByteArray();
                    int serRecordOffset = this.inputArg0.getStartOffset();
                    int serRecordLen = this.inputArg0.getLength();
                    if (serRecord[serRecordOffset] != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                        throw new TypeMismatchException(BuiltinFunctions.GET_RECORD_FIELD_VALUE, (Integer)0, serRecord[serRecordOffset], ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
                    }
                    int subFieldOffset = -1;
                    int subFieldLength = -1;
                    int subFieldIndex = this.recTypeInfo.getFieldIndex(serFldName, serFldNameOffset + 1, serFldNameLen - 1);
                    if (subFieldIndex >= 0) {
                        int nullBitmapSize = RecordUtil.computeNullBitmapSize((ARecordType)GetRecordFieldValueEvalFactory.this.recordType);
                        subFieldOffset = ARecordSerializerDeserializer.getFieldOffsetById((byte[])serRecord, (int)serRecordOffset, (int)subFieldIndex, (int)nullBitmapSize, (boolean)GetRecordFieldValueEvalFactory.this.recordType.isOpen());
                        if (subFieldOffset == 0) {
                            this.out.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                            result.set((IValueReference)this.resultStorage);
                            return;
                        }
                        ATypeTag fieldTypeTag = GetRecordFieldValueEvalFactory.this.recordType.getFieldTypes()[subFieldIndex].getTypeTag();
                        subFieldLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serRecord, (int)subFieldOffset, (ATypeTag)fieldTypeTag, (boolean)false);
                        this.out.writeByte(fieldTypeTag.serialize());
                        this.out.write(serRecord, subFieldOffset, subFieldLength);
                        result.set((IValueReference)this.resultStorage);
                        return;
                    }
                    subFieldOffset = ARecordSerializerDeserializer.getFieldOffsetByName((byte[])serRecord, (int)serRecordOffset, (int)serRecordLen, (byte[])serFldName, (int)serFldNameOffset);
                    if (subFieldOffset < 0) {
                        this.out.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
                        result.set((IValueReference)this.resultStorage);
                        return;
                    }
                    ATypeTag fieldValueTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serRecord[subFieldOffset]);
                    subFieldLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serRecord, (int)subFieldOffset, (ATypeTag)fieldValueTypeTag, (boolean)true) + 1;
                    result.set(serRecord, subFieldOffset, subFieldLength);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        };
    }

    static /* synthetic */ IScalarEvaluatorFactory access$000(GetRecordFieldValueEvalFactory x0) {
        return x0.recordEvalFactory;
    }

    static /* synthetic */ IScalarEvaluatorFactory access$100(GetRecordFieldValueEvalFactory x0) {
        return x0.fldNameEvalFactory;
    }
}

