/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ARecordSerializerDeserializer;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class FieldAccessByIndexEvalFactory
implements IScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private IScalarEvaluatorFactory recordEvalFactory;
    private IScalarEvaluatorFactory fieldIndexEvalFactory;
    private int nullBitmapSize;
    private ARecordType recordType;

    public FieldAccessByIndexEvalFactory(IScalarEvaluatorFactory recordEvalFactory, IScalarEvaluatorFactory fieldIndexEvalFactory, ARecordType recordType) {
        this.recordEvalFactory = recordEvalFactory;
        this.fieldIndexEvalFactory = fieldIndexEvalFactory;
        this.recordType = recordType;
        this.nullBitmapSize = RecordUtil.computeNullBitmapSize((ARecordType)recordType);
    }

    public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
        return new IScalarEvaluator(){
            private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
            private DataOutput out = this.resultStorage.getDataOutput();
            private IPointable inputArg0 = new VoidPointable();
            private IPointable inputArg1 = new VoidPointable();
            private IScalarEvaluator eval0 = FieldAccessByIndexEvalFactory.access$000(FieldAccessByIndexEvalFactory.this).createScalarEvaluator(ctx);
            private IScalarEvaluator eval1 = FieldAccessByIndexEvalFactory.access$100(FieldAccessByIndexEvalFactory.this).createScalarEvaluator(ctx);
            private int fieldIndex;
            private int fieldValueOffset;
            private int fieldValueLength;
            private IAType fieldValueType;
            private ATypeTag fieldValueTypeTag;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                try {
                    this.resultStorage.reset();
                    this.eval0.evaluate(tuple, this.inputArg0);
                    byte[] serRecord = this.inputArg0.getByteArray();
                    int offset = this.inputArg0.getStartOffset();
                    if (serRecord[offset] != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                        throw new TypeMismatchException(BuiltinFunctions.FIELD_ACCESS_BY_INDEX, (Integer)0, serRecord[offset], ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
                    }
                    this.eval1.evaluate(tuple, this.inputArg1);
                    byte[] indexBytes = this.inputArg1.getByteArray();
                    int indexOffset = this.inputArg1.getStartOffset();
                    if (indexBytes[indexOffset] != ATypeTag.SERIALIZED_INT32_TYPE_TAG) {
                        throw new TypeMismatchException(BuiltinFunctions.FIELD_ACCESS_BY_INDEX, (Integer)1, indexBytes[offset], ATypeTag.SERIALIZED_INT32_TYPE_TAG);
                    }
                    this.fieldIndex = IntegerPointable.getInteger((byte[])indexBytes, (int)(indexOffset + 1));
                    this.fieldValueType = FieldAccessByIndexEvalFactory.this.recordType.getFieldTypes()[this.fieldIndex];
                    this.fieldValueOffset = ARecordSerializerDeserializer.getFieldOffsetById((byte[])serRecord, (int)offset, (int)this.fieldIndex, (int)FieldAccessByIndexEvalFactory.this.nullBitmapSize, (boolean)FieldAccessByIndexEvalFactory.this.recordType.isOpen());
                    if (this.fieldValueOffset == 0) {
                        this.out.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                        result.set((IValueReference)this.resultStorage);
                        return;
                    }
                    if (this.fieldValueOffset < 0) {
                        this.out.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
                        result.set((IValueReference)this.resultStorage);
                        return;
                    }
                    if (this.fieldValueType.getTypeTag().equals((Object)ATypeTag.UNION)) {
                        if (!((AUnionType)this.fieldValueType).isUnknownableType()) throw new NotImplementedException();
                        this.fieldValueTypeTag = ((AUnionType)this.fieldValueType).getActualType().getTypeTag();
                        this.fieldValueLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serRecord, (int)this.fieldValueOffset, (ATypeTag)this.fieldValueTypeTag, (boolean)false);
                        this.out.writeByte(this.fieldValueTypeTag.serialize());
                    } else {
                        this.fieldValueTypeTag = this.fieldValueType.getTypeTag();
                        this.fieldValueLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serRecord, (int)this.fieldValueOffset, (ATypeTag)this.fieldValueTypeTag, (boolean)false);
                        this.out.writeByte(this.fieldValueTypeTag.serialize());
                    }
                    this.out.write(serRecord, this.fieldValueOffset, this.fieldValueLength);
                    result.set((IValueReference)this.resultStorage);
                    return;
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        };
    }

    static /* synthetic */ IScalarEvaluatorFactory access$000(FieldAccessByIndexEvalFactory x0) {
        return x0.recordEvalFactory;
    }

    static /* synthetic */ IScalarEvaluatorFactory access$100(FieldAccessByIndexEvalFactory x0) {
        return x0.fieldIndexEvalFactory;
    }
}

