/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ARecordSerializerDeserializer;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.runtime.evaluators.functions.records.FieldAccessByIndexEvalFactory$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class FieldAccessByIndexEvalFactory$_EvaluatorGen
implements IScalarEvaluator {
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private DataOutput out = this.resultStorage.getDataOutput();
    private IPointable inputArg0 = new VoidPointable();
    private IPointable inputArg1 = new VoidPointable();
    private IScalarEvaluator eval0 = FieldAccessByIndexEvalFactory$_EvaluatorFactoryGen.access$000(this.this$0).createScalarEvaluator(this.val$ctx);
    private IScalarEvaluator eval1 = FieldAccessByIndexEvalFactory$_EvaluatorFactoryGen.access$100(this.this$0).createScalarEvaluator(this.val$ctx);
    private int fieldIndex;
    private int fieldValueOffset;
    private int fieldValueLength;
    private IAType fieldValueType;
    private ATypeTag fieldValueTypeTag;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ FieldAccessByIndexEvalFactory$_EvaluatorFactoryGen this$0;
    private final TypeChecker typeChecker = new TypeChecker();

    FieldAccessByIndexEvalFactory$_EvaluatorGen(FieldAccessByIndexEvalFactory$_EvaluatorFactoryGen this$0, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$0 = this$0;
        this.val$ctx = iHyracksTaskContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            int indexOffset;
            int offset;
            this.resultStorage.reset();
            this.eval0.evaluate(tuple, this.inputArg0);
            if (this.typeChecker.isMissing(this.inputArg0, result)) {
                return;
            }
            byte[] serRecord = this.inputArg0.getByteArray();
            if (serRecord[offset = this.inputArg0.getStartOffset()] != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                throw new TypeMismatchException(BuiltinFunctions.FIELD_ACCESS_BY_INDEX, (Integer)0, serRecord[offset], ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
            }
            this.eval1.evaluate(tuple, this.inputArg1);
            if (this.typeChecker.isMissing(this.inputArg1, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            byte[] indexBytes = this.inputArg1.getByteArray();
            if (indexBytes[indexOffset = this.inputArg1.getStartOffset()] != ATypeTag.SERIALIZED_INT32_TYPE_TAG) {
                throw new TypeMismatchException(BuiltinFunctions.FIELD_ACCESS_BY_INDEX, (Integer)1, indexBytes[offset], ATypeTag.SERIALIZED_INT32_TYPE_TAG);
            }
            this.fieldIndex = IntegerPointable.getInteger((byte[])indexBytes, (int)(indexOffset + 1));
            this.fieldValueType = FieldAccessByIndexEvalFactory$_EvaluatorFactoryGen.access$200(this.this$0).getFieldTypes()[this.fieldIndex];
            this.fieldValueOffset = ARecordSerializerDeserializer.getFieldOffsetById((byte[])serRecord, (int)offset, (int)this.fieldIndex, (int)FieldAccessByIndexEvalFactory$_EvaluatorFactoryGen.access$300(this.this$0), (boolean)FieldAccessByIndexEvalFactory$_EvaluatorFactoryGen.access$200(this.this$0).isOpen());
            if (this.fieldValueOffset == 0) {
                this.out.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                result.set((IValueReference)this.resultStorage);
                return;
            }
            if (this.fieldValueOffset < 0) {
                this.out.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
                result.set((IValueReference)this.resultStorage);
                return;
            }
            if (this.fieldValueType.getTypeTag().equals((Object)ATypeTag.UNION)) {
                if (!((AUnionType)this.fieldValueType).isUnknownableType()) throw new NotImplementedException();
                this.fieldValueTypeTag = ((AUnionType)this.fieldValueType).getActualType().getTypeTag();
                this.fieldValueLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serRecord, (int)this.fieldValueOffset, (ATypeTag)this.fieldValueTypeTag, (boolean)false);
                this.out.writeByte(this.fieldValueTypeTag.serialize());
            } else {
                this.fieldValueTypeTag = this.fieldValueType.getTypeTag();
                this.fieldValueLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serRecord, (int)this.fieldValueOffset, (ATypeTag)this.fieldValueTypeTag, (boolean)false);
                this.out.writeByte(this.fieldValueTypeTag.serialize());
            }
            this.out.write(serRecord, this.fieldValueOffset, this.fieldValueLength);
            result.set((IValueReference)this.resultStorage);
            return;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

