/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.util.List;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.functions.ToAtomicDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.functions.ToAtomicDescriptor$_Gen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class ToAtomicDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private final IScalarEvaluator eval0;
    private final IPointable arg;
    private final PointableAllocator pAlloc;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ ToAtomicDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    ToAtomicDescriptor$_EvaluatorGen(ToAtomicDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.eval0 = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.arg = new VoidPointable();
        this.pAlloc = new PointableAllocator();
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable resultPointable) throws HyracksDataException {
        this.eval0.evaluate(tuple, this.arg);
        if (this.typeChecker.isMissing(this.arg, resultPointable)) {
            return;
        }
        if (this.typeChecker.isNull(resultPointable)) {
            return;
        }
        IPointable itemPtr = this.arg;
        IAType itemTypeInferred = ToAtomicDescriptor$_Gen.access$000(this.this$1.this$0);
        block4: while (true) {
            byte[] itemData = itemPtr.getByteArray();
            int itemOffset = itemPtr.getStartOffset();
            ATypeTag typeTag = ATypeTag.VALUE_TYPE_MAPPING[itemData[itemOffset]];
            switch (typeTag) {
                case ARRAY: 
                case MULTISET: {
                    AListVisitablePointable listPointable = (AListVisitablePointable)this.allocatePointable(itemTypeInferred, typeTag);
                    listPointable.set((IValueReference)itemPtr);
                    List listItems = listPointable.getItems();
                    if (listItems.size() != 1) {
                        PointableHelper.setNull(resultPointable);
                        return;
                    }
                    itemPtr = (IValueReference)listItems.get(0);
                    itemTypeInferred = this.getListItemType(itemTypeInferred);
                    continue block4;
                }
                case OBJECT: {
                    ARecordType recType = this.asRecordType(itemTypeInferred);
                    ARecordVisitablePointable recPointable = (ARecordVisitablePointable)this.allocatePointable(itemTypeInferred, typeTag);
                    recPointable.set((IValueReference)itemPtr);
                    List recValues = recPointable.getFieldValues();
                    if (recValues.size() != 1) {
                        PointableHelper.setNull(resultPointable);
                        return;
                    }
                    itemPtr = (IValueReference)recValues.get(0);
                    itemTypeInferred = recType.getFieldTypes().length == 1 ? recType.getFieldTypes()[0] : BuiltinType.ANY;
                    continue block4;
                }
            }
            break;
        }
        resultPointable.set((IValueReference)itemPtr);
    }

    private IVisitablePointable allocatePointable(IAType inferredType, ATypeTag actualTypeTag) {
        if (inferredType.equals(BuiltinType.ANY)) {
            return this.allocatePointableForAny(actualTypeTag);
        }
        return this.pAlloc.allocateFieldValue(inferredType);
    }

    private IVisitablePointable allocatePointableForAny(ATypeTag typeTag) {
        switch (typeTag) {
            case OBJECT: {
                return this.pAlloc.allocateFieldValue((IAType)DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
            }
            case ARRAY: {
                return this.pAlloc.allocateFieldValue((IAType)DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE);
            }
            case MULTISET: {
                return this.pAlloc.allocateFieldValue((IAType)DefaultOpenFieldType.NESTED_OPEN_AUNORDERED_LIST_TYPE);
            }
        }
        return this.pAlloc.allocateFieldValue(null);
    }

    private ARecordType asRecordType(IAType inferredType) {
        switch (inferredType.getTypeTag()) {
            case OBJECT: {
                return (ARecordType)inferredType;
            }
            case UNION: {
                IAType innerType = ((AUnionType)inferredType).getActualType();
                if (innerType.getTypeTag() != ATypeTag.OBJECT) break;
                return (ARecordType)innerType;
            }
        }
        return DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE;
    }

    private IAType getListItemType(IAType inferredType) {
        switch (inferredType.getTypeTag()) {
            case ARRAY: {
                return ((AOrderedListType)inferredType).getItemType();
            }
            case MULTISET: {
                return ((AUnorderedListType)inferredType).getItemType();
            }
            case UNION: {
                IAType innerType = ((AUnionType)inferredType).getActualType();
                switch (innerType.getTypeTag()) {
                    case ARRAY: {
                        return ((AOrderedListType)innerType).getItemType();
                    }
                    case MULTISET: {
                        return ((AUnorderedListType)innerType).getItemType();
                    }
                }
            }
        }
        return BuiltinType.ANY;
    }
}

