/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.StringConcatDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

class StringConcatDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final ListAccessor listAccessor = new ListAccessor();
    private final DataOutput out = this.resultStorage.getDataOutput();
    private final IScalarEvaluatorFactory listEvalFactory;
    private final IPointable inputArgList;
    private final IScalarEvaluator evalList;
    private ISerializerDeserializer<ANull> nullSerde;
    private ISerializerDeserializer<AMissing> missingSerde;
    private final byte[] tempLengthArray;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ StringConcatDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    StringConcatDescriptor$_EvaluatorGen(StringConcatDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.listEvalFactory = this.this$1.val$args[0];
        this.inputArgList = new VoidPointable();
        this.evalList = this.listEvalFactory.createScalarEvaluator(this.val$ctx);
        this.nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
        this.missingSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AMISSING);
        this.tempLengthArray = new byte[5];
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        try {
            int listOffset;
            this.evalList.evaluate(tuple, this.inputArgList);
            if (this.typeChecker.isMissing(this.inputArgList, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            byte[] listBytes = this.inputArgList.getByteArray();
            if (listBytes[listOffset = this.inputArgList.getStartOffset()] != ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG && listBytes[listOffset] != ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG) {
                throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), (Integer)0, listBytes[listOffset], ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG);
            }
            this.listAccessor.reset(listBytes, listOffset);
            int utf8Len = 0;
            for (int i = 0; i < this.listAccessor.size(); ++i) {
                int itemOffset = this.listAccessor.getItemOffset(i);
                ATypeTag itemType = this.listAccessor.getItemType(itemOffset);
                if (this.listAccessor.itemsAreSelfDescribing()) {
                    ++itemOffset;
                }
                if (itemType != ATypeTag.STRING) {
                    if (itemType == ATypeTag.NULL) {
                        this.nullSerde.serialize((Object)ANull.NULL, this.out);
                        result.set((IValueReference)this.resultStorage);
                        return;
                    }
                    if (itemType == ATypeTag.MISSING) {
                        this.missingSerde.serialize((Object)AMissing.MISSING, this.out);
                        result.set((IValueReference)this.resultStorage);
                        return;
                    }
                    throw new UnsupportedItemTypeException(this.this$1.this$0.getIdentifier(), itemType.serialize());
                }
                utf8Len += UTF8StringUtil.getUTFLength((byte[])listBytes, (int)itemOffset);
            }
            this.out.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
            int cbytes = UTF8StringUtil.encodeUTF8Length((int)utf8Len, (byte[])this.tempLengthArray, (int)0);
            this.out.write(this.tempLengthArray, 0, cbytes);
            for (int i = 0; i < this.listAccessor.size(); ++i) {
                int itemOffset = this.listAccessor.getItemOffset(i);
                if (this.listAccessor.itemsAreSelfDescribing()) {
                    ++itemOffset;
                }
                utf8Len = UTF8StringUtil.getUTFLength((byte[])listBytes, (int)itemOffset);
                this.out.write(listBytes, UTF8StringUtil.getNumBytesToStoreLength((int)utf8Len) + itemOffset, utf8Len);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }
}

