/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.functions.OrDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class OrDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private DataOutput output = this.resultStorage.getDataOutput();
    private ISerializerDeserializer<ABoolean> booleanSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
    private ISerializerDeserializer<ANull> nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
    private ISerializerDeserializer<AMissing> missingSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AMISSING);
    final /* synthetic */ IScalarEvaluator[] val$evals;
    final /* synthetic */ IPointable val$argPtr;
    final /* synthetic */ OrDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker = new TypeChecker();

    OrDescriptor$_EvaluatorGen(OrDescriptor$_EvaluatorFactoryGen this$1, IScalarEvaluator[] iScalarEvaluatorArray, IPointable iPointable) {
        this.this$1 = this$1;
        this.val$evals = iScalarEvaluatorArray;
        this.val$argPtr = iPointable;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        int n = this.this$1.val$args.length;
        boolean res = false;
        boolean metNull = false;
        boolean metMissing = false;
        for (int i = 0; i < n; ++i) {
            int offset;
            this.val$evals[i].evaluate(tuple, this.val$argPtr);
            if (this.typeChecker.isMissing(this.val$argPtr, result)) {
                return;
            }
            byte[] data = this.val$argPtr.getByteArray();
            if (data[offset = this.val$argPtr.getStartOffset()] == ATypeTag.SERIALIZED_MISSING_TYPE_TAG) {
                metMissing = true;
                continue;
            }
            if (data[offset] == ATypeTag.SERIALIZED_NULL_TYPE_TAG) {
                metNull = true;
                continue;
            }
            if (data[offset] != ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG) {
                throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), (Integer)i, data[offset], ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG);
            }
            boolean argResult = ABooleanSerializerDeserializer.getBoolean((byte[])data, (int)(offset + 1));
            if (argResult) {
                this.booleanSerde.serialize((Object)ABoolean.TRUE, this.output);
                result.set((IValueReference)this.resultStorage);
                return;
            }
            res |= argResult;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        if (metNull) {
            this.nullSerde.serialize((Object)ANull.NULL, this.output);
        } else if (metMissing) {
            this.missingSerde.serialize((Object)AMissing.MISSING, this.output);
        } else {
            ABoolean aResult = res ? ABoolean.TRUE : ABoolean.FALSE;
            this.booleanSerde.serialize((Object)aResult, this.output);
        }
        result.set((IValueReference)this.resultStorage);
    }
}

