/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.DoublePointable;
import org.apache.hyracks.data.std.primitive.FloatPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class IfNanOrInfDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private final IScalarEvaluator[] argEvals;
    private final IPointable argPtr;
    private final TypeChecker typeChecker;

    IfNanOrInfDescriptor$_EvaluatorGen(IHyracksTaskContext ctx, IScalarEvaluatorFactory[] args) throws HyracksDataException {
        this.argEvals = new IScalarEvaluator[args.length];
        for (int i = 0; i < this.argEvals.length; ++i) {
            this.argEvals[i] = args[i].createScalarEvaluator(ctx);
        }
        this.argPtr = new VoidPointable();
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        block5: for (int i = 0; i < this.argEvals.length; ++i) {
            this.argEvals[i].evaluate(tuple, this.argPtr);
            if (this.typeChecker.isMissing(this.argPtr, result)) {
                return;
            }
            ATypeTag argTypeTag = PointableHelper.getTypeTag((IValueReference)this.argPtr);
            if (argTypeTag == null) {
                throw new RuntimeDataException(6, new Serializable[]{this.getIdentifier(), Integer.valueOf(i)});
            }
            switch (argTypeTag) {
                case DOUBLE: {
                    double d = DoublePointable.getDouble((byte[])this.argPtr.getByteArray(), (int)(this.argPtr.getStartOffset() + 1));
                    if (this.skipDouble(d)) continue block5;
                    result.set((IValueReference)this.argPtr);
                    return;
                }
                case FLOAT: {
                    float f = FloatPointable.getFloat((byte[])this.argPtr.getByteArray(), (int)(this.argPtr.getStartOffset() + 1));
                    if (this.skipFloat(f)) continue block5;
                    result.set((IValueReference)this.argPtr);
                    return;
                }
                case BIGINT: 
                case INTEGER: 
                case SMALLINT: 
                case TINYINT: 
                case MISSING: {
                    result.set((IValueReference)this.argPtr);
                    return;
                }
                default: {
                    PointableHelper.setNull(result);
                    return;
                }
            }
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        PointableHelper.setNull(result);
    }

    protected abstract FunctionIdentifier getIdentifier();

    protected abstract boolean skipDouble(double var1);

    protected abstract boolean skipFloat(float var1);
}

