/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.runtime.evaluators.functions.GetItemDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class GetItemDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput output = this.resultStorage.getDataOutput();
    private IPointable inputArgList = new VoidPointable();
    private IPointable inputArgIdx = new VoidPointable();
    private IScalarEvaluator evalList = GetItemDescriptor$_EvaluatorFactoryGen.access$000(this.this$0).createScalarEvaluator(this.val$ctx);
    private IScalarEvaluator evalIdx = GetItemDescriptor$_EvaluatorFactoryGen.access$100(this.this$0).createScalarEvaluator(this.val$ctx);
    private byte[] missingBytes = new byte[]{ATypeTag.SERIALIZED_MISSING_TYPE_TAG};
    private int itemIndex;
    private int itemOffset;
    private int itemLength;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ GetItemDescriptor$_EvaluatorFactoryGen this$0;
    private final TypeChecker typeChecker = new TypeChecker();

    GetItemDescriptor$_EvaluatorGen(GetItemDescriptor$_EvaluatorFactoryGen this$0, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$0 = this$0;
        this.val$ctx = iHyracksTaskContext;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            this.evalList.evaluate(tuple, this.inputArgList);
            if (this.typeChecker.isMissing(this.inputArgList, result)) {
                return;
            }
            this.evalIdx.evaluate(tuple, this.inputArgIdx);
            if (this.typeChecker.isMissing(this.inputArgIdx, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            byte[] serOrderedList = this.inputArgList.getByteArray();
            int offset = this.inputArgList.getStartOffset();
            byte[] indexBytes = this.inputArgIdx.getByteArray();
            int indexOffset = this.inputArgIdx.getStartOffset();
            if (serOrderedList[offset] != ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG) {
                throw new TypeMismatchException(BuiltinFunctions.GET_ITEM, (Integer)0, serOrderedList[offset], ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG);
            }
            this.itemIndex = ATypeHierarchy.getIntegerValue((String)BuiltinFunctions.GET_ITEM.getName(), (int)0, (byte[])indexBytes, (int)indexOffset);
            if (this.itemIndex < 0 || this.itemIndex >= AOrderedListSerializerDeserializer.getNumberOfItems((byte[])serOrderedList, (int)offset)) {
                result.set(this.missingBytes, 0, 1);
                return;
            }
            GetItemDescriptor$_EvaluatorFactoryGen.access$202(this.this$0, (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serOrderedList[offset + 1]));
            if (GetItemDescriptor$_EvaluatorFactoryGen.access$200(this.this$0) == ATypeTag.ANY) {
                GetItemDescriptor$_EvaluatorFactoryGen.access$302(this.this$0, true);
            } else {
                GetItemDescriptor$_EvaluatorFactoryGen.access$402(this.this$0, serOrderedList[offset + 1]);
            }
            this.itemOffset = AOrderedListSerializerDeserializer.getItemOffset((byte[])serOrderedList, (int)offset, (int)this.itemIndex);
            if (GetItemDescriptor$_EvaluatorFactoryGen.access$300(this.this$0)) {
                GetItemDescriptor$_EvaluatorFactoryGen.access$202(this.this$0, (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serOrderedList[this.itemOffset]));
                this.itemLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serOrderedList, (int)this.itemOffset, (ATypeTag)GetItemDescriptor$_EvaluatorFactoryGen.access$200(this.this$0), (boolean)true) + 1;
                result.set(serOrderedList, this.itemOffset, this.itemLength);
            } else {
                this.itemLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serOrderedList, (int)this.itemOffset, (ATypeTag)GetItemDescriptor$_EvaluatorFactoryGen.access$200(this.this$0), (boolean)false);
                this.resultStorage.reset();
                this.output.writeByte(GetItemDescriptor$_EvaluatorFactoryGen.access$400(this.this$0));
                this.output.write(serOrderedList, this.itemOffset, this.itemLength);
                result.set((IValueReference)this.resultStorage);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

