/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

public abstract class AbstractBooleanConstructorEvaluator
implements IScalarEvaluator {
    protected static final ISerializerDeserializer<ABoolean> BOOLEAN_SERDE = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
    protected static final IBinaryComparator UTF8_BINARY_CMP = BinaryComparatorFactoryProvider.UTF8STRING_POINTABLE_INSTANCE.createBinaryComparator();
    protected static final byte[] TRUE = UTF8StringUtil.writeStringToBytes((String)"true");
    protected static final byte[] FALSE = UTF8StringUtil.writeStringToBytes((String)"false");
    protected final IScalarEvaluator inputEval;
    protected final IPointable inputArg;
    protected final ArrayBackedValueStorage resultStorage;
    protected final DataOutput out;

    protected AbstractBooleanConstructorEvaluator(IScalarEvaluator inputEval) {
        this.inputEval = inputEval;
        this.inputArg = new VoidPointable();
        this.resultStorage = new ArrayBackedValueStorage();
        this.out = this.resultStorage.getDataOutput();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            this.inputEval.evaluate(tuple, this.inputArg);
            this.resultStorage.reset();
            this.evaluateImpl(result);
        }
        catch (IOException e) {
            throw new InvalidDataFormatException(this.getIdentifier(), e, ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void evaluateImpl(IPointable result) throws HyracksDataException {
        int startOffset;
        byte[] bytes = this.inputArg.getByteArray();
        byte tt = bytes[startOffset = this.inputArg.getStartOffset()];
        if (tt == ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG) {
            result.set((IValueReference)this.inputArg);
            return;
        } else {
            if (tt != ATypeTag.SERIALIZED_STRING_TYPE_TAG) throw new TypeMismatchException(this.getIdentifier(), (Integer)0, tt, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
            int len = this.inputArg.getLength();
            if (UTF8_BINARY_CMP.compare(bytes, startOffset + 1, len - 1, TRUE, 0, TRUE.length) == 0) {
                this.setBoolean(result, true);
                return;
            } else {
                if (UTF8_BINARY_CMP.compare(bytes, startOffset + 1, len - 1, FALSE, 0, FALSE.length) != 0) throw new InvalidDataFormatException(this.getIdentifier(), ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG);
                this.setBoolean(result, false);
            }
        }
    }

    protected void setBoolean(IPointable result, boolean value) throws HyracksDataException {
        BOOLEAN_SERDE.serialize((Object)ABoolean.valueOf((boolean)value), this.out);
        result.set((IValueReference)this.resultStorage);
    }

    protected abstract FunctionIdentifier getIdentifier();
}

