/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.common;

import java.io.DataOutput;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.BinaryTokenizerFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.functions.FullTextContainsDescriptor;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.accessors.PointableBinaryHashFunctionFactory;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.TaggedValuePointable;
import org.apache.hyracks.data.std.primitive.UTF8StringLowercaseTokenPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.BinaryEntry;
import org.apache.hyracks.data.std.util.BinaryHashSet;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.DelimitedUTF8StringBinaryTokenizer;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizer;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class FullTextContainsEvaluator
implements IScalarEvaluator {
    protected static final int TYPE_INDICATOR_SIZE = 1;
    protected final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    protected final DataOutput out = this.resultStorage.getDataOutput();
    protected final TaggedValuePointable argLeft = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
    protected final TaggedValuePointable argRight = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
    protected TaggedValuePointable[] argOptions;
    protected final IScalarEvaluator evalLeft;
    protected final IScalarEvaluator evalRight;
    protected IScalarEvaluator[] evalOptions;
    protected IPointable outLeft = VoidPointable.FACTORY.createPointable();
    protected IPointable outRight = VoidPointable.FACTORY.createPointable();
    protected IPointable[] outOptions;
    protected int optionArgsLength;
    private final IBinaryComparator strLowerCaseTokenCmp = BinaryComparatorFactoryProvider.UTF8STRING_LOWERCASE_TOKEN_POINTABLE_INSTANCE.createBinaryComparator();
    private final IBinaryComparator strLowerCaseCmp = BinaryComparatorFactoryProvider.UTF8STRING_LOWERCASE_POINTABLE_INSTANCE.createBinaryComparator();
    private IBinaryTokenizer tokenizerForLeftArray = null;
    private IBinaryTokenizer tokenizerForRightArray = null;
    private IBinaryHashFunction hashFunc = null;
    private BinaryEntry keyEntry = null;
    private BinaryHashSet rightHashSet = null;
    private byte[] queryArray = null;
    private int queryArrayStartOffset = -1;
    private int queryArrayLength = -1;
    private int occurrenceThreshold = 1;
    static final int HASH_SET_SLOT_SIZE = 101;
    static final int HASH_SET_FRAME_SIZE = 32768;
    protected ISerializerDeserializer<ABoolean> serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
    protected ISerializerDeserializer<ANull> nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);

    public FullTextContainsEvaluator(IScalarEvaluatorFactory[] args, IHyracksTaskContext context) throws HyracksDataException {
        this.evalLeft = args[0].createScalarEvaluator(context);
        this.evalRight = args[1].createScalarEvaluator(context);
        this.optionArgsLength = args.length - 2;
        this.evalOptions = new IScalarEvaluator[this.optionArgsLength];
        this.outOptions = new IPointable[this.optionArgsLength];
        this.argOptions = new TaggedValuePointable[this.optionArgsLength];
        for (int i = 0; i < this.optionArgsLength; ++i) {
            this.evalOptions[i] = args[i + 2].createScalarEvaluator(context);
            this.outOptions[i] = VoidPointable.FACTORY.createPointable();
            this.argOptions[i] = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
        }
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        ATypeTag typeTag2;
        this.resultStorage.reset();
        this.evalLeft.evaluate(tuple, (IPointable)this.argLeft);
        this.argLeft.getValue(this.outLeft);
        this.evalRight.evaluate(tuple, (IPointable)this.argRight);
        this.argRight.getValue(this.outRight);
        for (int i = 0; i < this.optionArgsLength; ++i) {
            this.evalOptions[i].evaluate(tuple, (IPointable)this.argOptions[i]);
            this.argOptions[i].getValue(this.outOptions[i]);
        }
        ATypeTag typeTag1 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argLeft.getTag());
        if (!this.checkArgTypes(typeTag1, typeTag2 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argRight.getTag()))) {
            try {
                this.nullSerde.serialize((Object)ANull.NULL, this.out);
            }
            catch (HyracksDataException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            result.set((IValueReference)this.resultStorage);
            return;
        }
        try {
            ABoolean b = this.fullTextContainsWithArg(typeTag2, (IPointable)this.argLeft, (IPointable)this.argRight) ? ABoolean.TRUE : ABoolean.FALSE;
            this.serde.serialize((Object)b, this.out);
        }
        catch (HyracksDataException e1) {
            throw HyracksDataException.create((Throwable)e1);
        }
        result.set((IValueReference)this.resultStorage);
    }

    private boolean fullTextContainsWithArg(ATypeTag typeTag2, IPointable arg1, IPointable arg2) throws HyracksDataException {
        byte[] arg2Array;
        if (this.rightHashSet == null) {
            this.initializeFullTextContains();
        }
        if (!FullTextContainsEvaluator.partOfArrayEquals(this.queryArray, this.queryArrayStartOffset, this.queryArrayLength, arg2Array = arg2.getByteArray(), arg2.getStartOffset(), arg2.getLength())) {
            this.resetQueryArrayAndRight(arg2Array, typeTag2, arg2);
        } else {
            this.rightHashSet.clearFoundCount();
        }
        return this.readLeftAndConductSearch(arg1);
    }

    private void initializeFullTextContains() {
        this.hashFunc = new PointableBinaryHashFunctionFactory(UTF8StringLowercaseTokenPointable.FACTORY).createBinaryHashFunction();
        this.keyEntry = new BinaryEntry();
        this.rightHashSet = new BinaryHashSet(101, 32768, this.hashFunc, this.strLowerCaseTokenCmp, null);
        this.tokenizerForLeftArray = BinaryTokenizerFactoryProvider.INSTANCE.getWordTokenizerFactory(ATypeTag.STRING, false, true).createTokenizer();
    }

    void resetQueryArrayAndRight(byte[] arg2Array, ATypeTag typeTag2, IPointable arg2) throws HyracksDataException {
        int numBytesToStoreLength;
        switch (typeTag2) {
            case ARRAY: {
                this.tokenizerForRightArray = BinaryTokenizerFactoryProvider.INSTANCE.getWordTokenizerFactory(ATypeTag.ARRAY, false, true).createTokenizer();
                break;
            }
            case MULTISET: {
                this.tokenizerForRightArray = BinaryTokenizerFactoryProvider.INSTANCE.getWordTokenizerFactory(ATypeTag.MULTISET, false, true).createTokenizer();
                break;
            }
            case STRING: {
                this.tokenizerForRightArray = BinaryTokenizerFactoryProvider.INSTANCE.getWordTokenizerFactory(ATypeTag.STRING, false, true).createTokenizer();
                break;
            }
        }
        this.queryArray = arg2Array;
        this.queryArrayStartOffset = arg2.getStartOffset();
        this.queryArrayLength = arg2.getLength();
        this.rightHashSet.clear();
        this.rightHashSet.setRefArray(this.queryArray);
        int queryTokenCount = 0;
        int uniqueQueryTokenCount = 0;
        if (typeTag2 == ATypeTag.STRING) {
            numBytesToStoreLength = UTF8StringUtil.getNumBytesToStoreLength((int)UTF8StringUtil.getUTFLength((byte[])this.queryArray, (int)this.queryArrayStartOffset));
            this.queryArrayStartOffset += numBytesToStoreLength;
            this.queryArrayLength -= numBytesToStoreLength;
        }
        this.tokenizerForRightArray.reset(this.queryArray, this.queryArrayStartOffset, this.queryArrayLength);
        while (this.tokenizerForRightArray.hasNext()) {
            this.tokenizerForRightArray.next();
            ++queryTokenCount;
            int tokenOffset = this.tokenizerForRightArray.getToken().getStartOffset();
            int tokenLength = this.tokenizerForRightArray.getToken().getTokenLength();
            if (typeTag2 == ATypeTag.ARRAY || typeTag2 == ATypeTag.MULTISET) {
                numBytesToStoreLength = UTF8StringUtil.getNumBytesToStoreLength((int)UTF8StringUtil.getUTFLength((byte[])this.tokenizerForRightArray.getToken().getData(), (int)this.tokenizerForRightArray.getToken().getStartOffset()));
                tokenOffset += numBytesToStoreLength;
                tokenLength -= numBytesToStoreLength;
            }
            this.keyEntry.set(tokenOffset, tokenLength);
            this.checkWhetherFullTextPredicateIsPhrase(typeTag2, this.queryArray, tokenOffset, tokenLength, queryTokenCount);
            if (this.rightHashSet.find(this.keyEntry, this.queryArray, false) != -1) continue;
            this.rightHashSet.put(this.keyEntry);
            ++uniqueQueryTokenCount;
        }
        this.setFullTextOption((IPointable[])this.argOptions, uniqueQueryTokenCount);
    }

    private void checkWhetherFullTextPredicateIsPhrase(ATypeTag typeTag, byte[] refArray, int tokenOffset, int tokenLength, int queryTokenCount) throws HyracksDataException {
        switch (typeTag) {
            case STRING: {
                if (queryTokenCount <= 1) break;
                throw new HyracksDataException("Phrase in Full-text search is not supported. An expression should include only one word.");
            }
            case ARRAY: 
            case MULTISET: {
                for (int j = 0; j < tokenLength; ++j) {
                    if (!DelimitedUTF8StringBinaryTokenizer.isSeparator((char)((char)refArray[tokenOffset + j]))) continue;
                    throw new HyracksDataException("Phrase in Full-text is not supported. An expression should include only one word." + (char)refArray[tokenOffset + j] + " " + refArray[tokenOffset + j]);
                }
                break;
            }
            default: {
                throw new HyracksDataException("Full-text search can be only executed on STRING or (UN)ORDERED LIST.");
            }
        }
    }

    private void setFullTextOption(IPointable[] argOptions, int uniqueQueryTokenCount) throws HyracksDataException {
        this.occurrenceThreshold = uniqueQueryTokenCount;
        for (int i = 0; i < this.optionArgsLength; i += 2) {
            if (this.compareStrInByteArrayAndPointable(FullTextContainsDescriptor.getSearchModeOptionArray(), argOptions[i], true) != 0) continue;
            if (this.compareStrInByteArrayAndPointable(FullTextContainsDescriptor.getDisjunctiveFTSearchOptionArray(), argOptions[i + 1], true) == 0) {
                this.occurrenceThreshold = 1;
                continue;
            }
            if (this.compareStrInByteArrayAndPointable(FullTextContainsDescriptor.getConjunctiveFTSearchOptionArray(), argOptions[i + 1], true) != 0) continue;
            this.occurrenceThreshold = uniqueQueryTokenCount;
        }
    }

    boolean readLeftAndConductSearch(IPointable arg1) throws HyracksDataException {
        int foundCount = 0;
        int numBytesToStoreLength = UTF8StringUtil.getNumBytesToStoreLength((int)UTF8StringUtil.getUTFLength((byte[])arg1.getByteArray(), (int)arg1.getStartOffset()));
        int startOffset = arg1.getStartOffset() + numBytesToStoreLength;
        int length = arg1.getLength() - numBytesToStoreLength;
        this.tokenizerForLeftArray.reset(arg1.getByteArray(), startOffset, length);
        while (this.tokenizerForLeftArray.hasNext()) {
            this.tokenizerForLeftArray.next();
            this.keyEntry.set(this.tokenizerForLeftArray.getToken().getStartOffset(), this.tokenizerForLeftArray.getToken().getTokenLength());
            if (this.rightHashSet.find(this.keyEntry, arg1.getByteArray(), true) != 1 || ++foundCount < this.occurrenceThreshold) continue;
            return true;
        }
        return false;
    }

    private int compareStrInByteArrayAndPointable(byte[] left, IPointable right, boolean rightTypeTagIncluded) throws HyracksDataException {
        int rightTypeTagLength = rightTypeTagIncluded ? 1 : 0;
        return this.strLowerCaseCmp.compare(left, 0, left.length, right.getByteArray(), right.getStartOffset() + rightTypeTagLength, right.getLength() - rightTypeTagLength);
    }

    protected boolean checkArgTypes(ATypeTag typeTag1, ATypeTag typeTag2) throws HyracksDataException {
        return typeTag1 == ATypeTag.STRING && (typeTag2 == ATypeTag.ARRAY || typeTag2 == ATypeTag.MULTISET || ATypeHierarchy.isCompatible((ATypeTag)typeTag1, (ATypeTag)typeTag2));
    }

    private static boolean partOfArrayEquals(byte[] array1, int start1, int length1, byte[] array2, int start2, int length2) {
        if (length1 != length2 || array1 == null || array2 == null) {
            return false;
        }
        if (array1 == array2 && start1 == start2 && length1 == length2) {
            return true;
        }
        for (int offset = 0; offset < length1; ++offset) {
            if (array1[start1 + offset] == array2[start2 + offset]) continue;
            return false;
        }
        return true;
    }
}

