/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.std;

import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractCountAggregateFunction
implements IAggregateEvaluator {
    private AMutableInt64 result = new AMutableInt64(-1L);
    private ISerializerDeserializer<AInt64> int64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    private IPointable inputVal = new VoidPointable();
    private IScalarEvaluator eval;
    protected long cnt;
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();

    public AbstractCountAggregateFunction(IScalarEvaluatorFactory[] args, IHyracksTaskContext context) throws HyracksDataException {
        this.eval = args[0].createScalarEvaluator(context);
    }

    public void init() throws HyracksDataException {
        this.cnt = 0L;
    }

    public void step(IFrameTupleReference tuple) throws HyracksDataException {
        this.eval.evaluate(tuple, this.inputVal);
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.inputVal.getByteArray()[this.inputVal.getStartOffset()]);
        if (typeTag == ATypeTag.NULL || typeTag == ATypeTag.MISSING) {
            this.processNull();
        } else if (typeTag != ATypeTag.SYSTEM_NULL) {
            ++this.cnt;
        }
    }

    public void finish(IPointable resultPointable) throws HyracksDataException {
        this.resultStorage.reset();
        try {
            this.result.setValue(this.cnt);
            this.int64Serde.serialize((Object)this.result, this.resultStorage.getDataOutput());
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        resultPointable.set((IValueReference)this.resultStorage);
    }

    public void finishPartial(IPointable resultPointable) throws HyracksDataException {
        this.finish(resultPointable);
    }

    protected abstract void processNull();
}

