/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.collections;

import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class FirstElementEvalFactory
implements IAggregateEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private final IScalarEvaluatorFactory[] args;
    private final boolean isLocal;

    FirstElementEvalFactory(IScalarEvaluatorFactory[] args, boolean isLocal) {
        this.args = args;
        this.isLocal = isLocal;
    }

    public IAggregateEvaluator createAggregateEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
        return new IAggregateEvaluator(){
            private boolean first = true;
            private ArrayBackedValueStorage outputVal = new ArrayBackedValueStorage();
            private IPointable inputVal = new VoidPointable();
            private IScalarEvaluator eval = FirstElementEvalFactory.access$000(FirstElementEvalFactory.this)[0].createScalarEvaluator(ctx);
            private final byte[] nullBytes = new byte[]{ATypeTag.SERIALIZED_NULL_TYPE_TAG};
            private final byte[] systemNullBytes = new byte[]{ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG};

            public void init() throws HyracksDataException {
                this.first = true;
            }

            public void step(IFrameTupleReference tuple) throws HyracksDataException {
                if (!this.first) {
                    return;
                }
                this.eval.evaluate(tuple, this.inputVal);
                byte typeTagByte = this.inputVal.getByteArray()[this.inputVal.getStartOffset()];
                if (typeTagByte == ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG) {
                    return;
                }
                this.outputVal.assign((IValueReference)this.inputVal);
                this.first = false;
            }

            public void finish(IPointable result) throws HyracksDataException {
                if (this.first) {
                    result.set(FirstElementEvalFactory.this.isLocal ? this.systemNullBytes : this.nullBytes, 0, 1);
                    return;
                }
                result.set((IValueReference)this.outputVal);
            }

            public void finishPartial(IPointable result) throws HyracksDataException {
                this.finish(result);
            }
        };
    }

    static /* synthetic */ IScalarEvaluatorFactory[] access$000(FirstElementEvalFactory x0) {
        return x0.args;
    }
}

