/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util.string;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.apache.hyracks.util.encoding.VarLenIntEncoderDecoder;
import org.apache.hyracks.util.string.UTF8StringReader;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class UTF8StringUtil {
    public static char charAt(byte[] b, int s) {
        if (s >= b.length) {
            throw new ArrayIndexOutOfBoundsException(s);
        }
        int c = b[s] & 0xFF;
        switch (c >> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return (char)c;
            }
            case 12: 
            case 13: {
                return (char)((c & 0x1F) << 6 | b[s + 1] & 0x3F);
            }
            case 14: {
                return (char)((c & 0xF) << 12 | (b[s + 1] & 0x3F) << 6 | (b[s + 2] & 0x3F) << 0);
            }
        }
        throw new IllegalArgumentException();
    }

    public static int charSize(byte[] b, int s) {
        int c = b[s] & 0xFF;
        switch (c >> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 1;
            }
            case 12: 
            case 13: {
                return 2;
            }
            case 14: {
                return 3;
            }
        }
        throw new IllegalStateException();
    }

    public static int getModifiedUTF8Len(char c) {
        if (c >= '\u0001' && c <= '\u007f') {
            return 1;
        }
        if (c <= '\u07ff') {
            return 2;
        }
        return 3;
    }

    public static int writeCharAsModifiedUTF8(char c, DataOutput dos) throws IOException {
        if (c >= '\u0001' && c <= '\u007f') {
            dos.writeByte(c);
            return 1;
        }
        if (c <= '\u07ff') {
            dos.writeByte((byte)(0xC0 | c >> 6 & 0x3F));
            dos.writeByte((byte)(0x80 | c & 0x3F));
            return 2;
        }
        dos.writeByte((byte)(0xE0 | c >> 12 & 0xF));
        dos.writeByte((byte)(0x80 | c >> 6 & 0x3F));
        dos.writeByte((byte)(0x80 | c & 0x3F));
        return 3;
    }

    public static int writeCharAsModifiedUTF8(char c, OutputStream dos) throws IOException {
        if (c >= '\u0001' && c <= '\u007f') {
            dos.write(c);
            return 1;
        }
        if (c <= '\u07ff') {
            dos.write((byte)(0xC0 | c >> 6 & 0x3F));
            dos.write((byte)(0x80 | c & 0x3F));
            return 2;
        }
        dos.write((byte)(0xE0 | c >> 12 & 0xF));
        dos.write((byte)(0x80 | c >> 6 & 0x3F));
        dos.write((byte)(0x80 | c & 0x3F));
        return 3;
    }

    public static int getStringLength(byte[] b, int s) {
        int pos;
        int len = UTF8StringUtil.getUTFLength(b, s);
        int end = pos + len;
        int charCount = 0;
        for (pos = s + UTF8StringUtil.getNumBytesToStoreLength(len); pos < end; pos += UTF8StringUtil.charSize(b, pos)) {
            ++charCount;
        }
        return charCount;
    }

    public static int getUTFLength(byte[] b, int s) {
        return VarLenIntEncoderDecoder.decode(b, s);
    }

    public static int getNumBytesToStoreLength(int strlen) {
        return VarLenIntEncoderDecoder.getBytesRequired(strlen);
    }

    public static int UTF8ToCodePoint(byte[] b, int s) {
        if (b[s] >> 7 == 0) {
            return b[s];
        }
        if ((b[s] & 0xE0) == 192) {
            return (b[s] & 0x1F) << 6 | b[s + 1] & 0x3F;
        }
        if ((b[s] & 0xF0) == 224) {
            return (b[s] & 0xF) << 12 | (b[s + 1] & 0x3F) << 6 | b[s + 2] & 0x3F;
        }
        if ((b[s] & 0xF8) == 240) {
            return (b[s] & 7) << 18 | (b[s + 1] & 0x3F) << 12 | (b[s + 2] & 0x3F) << 6 | b[s + 3] & 0x3F;
        }
        if ((b[s] & 0xFC) == 248) {
            return (b[s] & 3) << 24 | (b[s + 1] & 0x3F) << 18 | (b[s + 2] & 0x3F) << 12 | (b[s + 3] & 0x3F) << 6 | b[s + 4] & 0x3F;
        }
        if ((b[s] & 0xFE) == 252) {
            return (b[s] & 1) << 30 | (b[s + 1] & 0x3F) << 24 | (b[s + 2] & 0x3F) << 18 | (b[s + 3] & 0x3F) << 12 | (b[s + 4] & 0x3F) << 6 | b[s + 5] & 0x3F;
        }
        return 0;
    }

    public static int codePointToUTF8(int c, byte[] outputUTF8) {
        if (c < 128) {
            outputUTF8[0] = (byte)(c & 0x7F);
            return 1;
        }
        if (c < 2048) {
            outputUTF8[0] = (byte)(c >> 6 & 0x1F | 0xC0);
            outputUTF8[1] = (byte)(c & 0x3F | 0x80);
            return 2;
        }
        if (c < 65536) {
            outputUTF8[0] = (byte)(c >> 12 & 0xF | 0xE0);
            outputUTF8[1] = (byte)(c >> 6 & 0x3F | 0x80);
            outputUTF8[2] = (byte)(c & 0x3F | 0x80);
            return 3;
        }
        if (c < 0x200000) {
            outputUTF8[0] = (byte)(c >> 18 & 7 | 0xF0);
            outputUTF8[1] = (byte)(c >> 12 & 0x3F | 0x80);
            outputUTF8[2] = (byte)(c >> 6 & 0x3F | 0x80);
            outputUTF8[3] = (byte)(c & 0x3F | 0x80);
            return 4;
        }
        if (c < 0x4000000) {
            outputUTF8[0] = (byte)(c >> 24 & 3 | 0xF8);
            outputUTF8[1] = (byte)(c >> 18 & 0x3F | 0x80);
            outputUTF8[2] = (byte)(c >> 12 & 0x3F | 0x80);
            outputUTF8[3] = (byte)(c >> 6 & 0x3F | 0x80);
            outputUTF8[4] = (byte)(c & 0x3F | 0x80);
            return 5;
        }
        if (c < Integer.MIN_VALUE) {
            outputUTF8[0] = (byte)(c >> 30 & 1 | 0xFC);
            outputUTF8[1] = (byte)(c >> 24 & 0x3F | 0x80);
            outputUTF8[2] = (byte)(c >> 18 & 0x3F | 0x80);
            outputUTF8[3] = (byte)(c >> 12 & 0x3F | 0x80);
            outputUTF8[4] = (byte)(c >> 6 & 0x3F | 0x80);
            outputUTF8[5] = (byte)(c & 0x3F | 0x80);
            return 6;
        }
        return 0;
    }

    public static int normalize(byte[] bytes, int start) {
        int len = UTF8StringUtil.getUTFLength(bytes, start);
        long nk = 0L;
        int offset = start + UTF8StringUtil.getNumBytesToStoreLength(len);
        for (int i = 0; i < 2; ++i) {
            nk <<= 16;
            if (i >= len) continue;
            nk += (long)(UTF8StringUtil.charAt(bytes, offset) & 0xFFFF);
            offset += UTF8StringUtil.charSize(bytes, offset);
        }
        return (int)(nk >> 1);
    }

    public static int compareTo(byte[] thisBytes, int thisStart, byte[] thatBytes, int thatStart) {
        return UTF8StringUtil.compareTo(thisBytes, thisStart, thatBytes, thatStart, false, false);
    }

    public static int rawByteCompareTo(byte[] thisBytes, int thisStart, byte[] thatBytes, int thatStart) {
        return UTF8StringUtil.compareTo(thisBytes, thisStart, thatBytes, thatStart, false, true);
    }

    public static int lowerCaseCompareTo(byte[] thisBytes, int thisStart, byte[] thatBytes, int thatStart) {
        return UTF8StringUtil.compareTo(thisBytes, thisStart, thatBytes, thatStart, true, false);
    }

    public static int lowerCaseCompareTo(byte[] thisBytes, int thisStart, int thisLength, byte[] thatBytes, int thatStart, int thatLength) {
        return UTF8StringUtil.compareTo(thisBytes, thisStart, thisLength, thatBytes, thatStart, thatLength, true, false);
    }

    public static int hash(byte[] bytes, int start, int coefficient, int r) {
        return UTF8StringUtil.hash(bytes, start, false, false, coefficient, r);
    }

    public static int hash(byte[] bytes, int start) {
        return UTF8StringUtil.hash(bytes, start, false, false, 31, Integer.MAX_VALUE);
    }

    private static int hash(byte[] bytes, int start, boolean useLowerCase, boolean useRawByte, int coefficient, int r) {
        int utflen = UTF8StringUtil.getUTFLength(bytes, start);
        int sStart = start + UTF8StringUtil.getNumBytesToStoreLength(utflen);
        return UTF8StringUtil.hash(bytes, sStart, utflen, useLowerCase, useRawByte, coefficient, r);
    }

    public static int rawBytehash(byte[] bytes, int start) {
        return UTF8StringUtil.hash(bytes, start, false, true, 31, Integer.MAX_VALUE);
    }

    public static int lowerCaseHash(byte[] bytes, int start) {
        return UTF8StringUtil.hash(bytes, start, true, false, 31, Integer.MAX_VALUE);
    }

    public static int lowerCaseHash(byte[] bytes, int start, int length) {
        return UTF8StringUtil.hash(bytes, start, length, true, false, 31, Integer.MAX_VALUE);
    }

    public static StringBuilder toString(StringBuilder builder, byte[] bytes, int start) {
        int cLen;
        int utfLen;
        int offset = UTF8StringUtil.getNumBytesToStoreLength(utfLen);
        for (utfLen = UTF8StringUtil.getUTFLength(bytes, start); utfLen > 0; utfLen -= cLen) {
            char c = UTF8StringUtil.charAt(bytes, start + offset);
            builder.append(c);
            cLen = UTF8StringUtil.getModifiedUTF8Len(c);
            offset += cLen;
        }
        return builder;
    }

    public static void printUTF8StringWithQuotes(byte[] b, int s, int l, OutputStream os) throws IOException {
        UTF8StringUtil.printUTF8String(b, s, l, os, true);
    }

    public static void printUTF8StringNoQuotes(byte[] b, int s, int l, OutputStream os) throws IOException {
        UTF8StringUtil.printUTF8String(b, s, l, os, false);
    }

    public static void printUTF8StringWithQuotes(String str, OutputStream os) throws IOException {
        UTF8StringUtil.printUTF8String(str, os, true);
    }

    public static void printUTF8StringNoQuotes(String str, OutputStream os) throws IOException {
        UTF8StringUtil.printUTF8String(str, os, false);
    }

    public static int encodeUTF8Length(int length, byte[] bytes, int start) {
        return VarLenIntEncoderDecoder.encode(length, bytes, start);
    }

    public static int writeUTF8Length(int length, byte[] bytes, DataOutput out) throws IOException {
        int nbytes = UTF8StringUtil.encodeUTF8Length(length, bytes, 0);
        out.write(bytes, 0, nbytes);
        return nbytes;
    }

    private static void printUTF8String(byte[] b, int s, int l, OutputStream os, boolean useQuotes) throws IOException {
        int stringLength = UTF8StringUtil.getUTFLength(b, s);
        int position = s + UTF8StringUtil.getNumBytesToStoreLength(stringLength);
        int maxPosition = position + stringLength;
        if (useQuotes) {
            os.write(34);
        }
        while (position < maxPosition) {
            char c = UTF8StringUtil.charAt(b, position);
            switch (c) {
                case '\"': 
                case '\\': {
                    os.write(92);
                }
            }
            for (int sz = UTF8StringUtil.charSize(b, position); sz > 0; --sz) {
                os.write(b[position]);
                ++position;
            }
        }
        if (useQuotes) {
            os.write(34);
        }
    }

    private static void printUTF8String(String string, OutputStream os, boolean useQuotes) throws IOException {
        if (useQuotes) {
            os.write(34);
        }
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            UTF8StringUtil.writeCharAsModifiedUTF8(ch, os);
        }
        if (useQuotes) {
            os.write(34);
        }
    }

    private static int compareTo(byte[] thisBytes, int thisStart, byte[] thatBytes, int thatStart, boolean useLowerCase, boolean useRawByte) {
        int thisLength = UTF8StringUtil.getUTFLength(thisBytes, thisStart);
        int thatLength = UTF8StringUtil.getUTFLength(thatBytes, thatStart);
        int thisActualStart = thisStart + UTF8StringUtil.getNumBytesToStoreLength(thisLength);
        int thatActualStart = thatStart + UTF8StringUtil.getNumBytesToStoreLength(thatLength);
        return UTF8StringUtil.compareTo(thisBytes, thisActualStart, thisLength, thatBytes, thatActualStart, thatLength, useLowerCase, useRawByte);
    }

    private static int compareTo(byte[] thisBytes, int thisActualStart, int thisLength, byte[] thatBytes, int thatActualStart, int thatLength, boolean useLowerCase, boolean useRawByte) {
        int c1 = 0;
        for (int c2 = 0; c1 < thisLength && c2 < thatLength; c1 += UTF8StringUtil.charSize(thisBytes, thisActualStart + c1), c2 += UTF8StringUtil.charSize(thatBytes, thatActualStart + c2)) {
            char ch2;
            char ch1;
            if (useRawByte) {
                ch1 = (char)thisBytes[thisActualStart + c1];
                ch2 = (char)thatBytes[thatActualStart + c2];
            } else {
                ch1 = UTF8StringUtil.charAt(thisBytes, thisActualStart + c1);
                ch2 = UTF8StringUtil.charAt(thatBytes, thatActualStart + c2);
                if (useLowerCase) {
                    ch1 = Character.toLowerCase(ch1);
                    ch2 = Character.toLowerCase(ch2);
                }
            }
            if (ch1 == ch2) continue;
            return ch1 - ch2;
        }
        return thisLength - thatLength;
    }

    private static int hash(byte[] bytes, int start, int length, boolean useLowerCase, boolean useRawByte, int coefficient, int r) {
        int h = 0;
        for (int c = 0; c < length; c += UTF8StringUtil.charSize(bytes, start + c)) {
            char ch;
            if (useRawByte) {
                ch = (char)bytes[start + c];
            } else {
                ch = UTF8StringUtil.charAt(bytes, start + c);
                if (useLowerCase) {
                    ch = Character.toLowerCase(ch);
                }
            }
            h = (coefficient * h + ch) % r;
        }
        return h;
    }

    public static byte[] writeStringToBytes(String string) {
        UTF8StringWriter writer = new UTF8StringWriter();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            writer.writeUTF8(string, dos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bos.toByteArray();
    }

    public static String readUTF8(DataInput in) throws IOException {
        return UTF8StringUtil.readUTF8(in, null);
    }

    public static String readUTF8(DataInput in, UTF8StringReader reader) throws IOException {
        int c;
        int count;
        char[] chararr;
        byte[] bytearr;
        int utflen = VarLenIntEncoderDecoder.decode(in);
        if (reader == null) {
            bytearr = new byte[utflen * 2];
            chararr = new char[utflen * 2];
        } else {
            if (reader.bytearr == null || reader.bytearr.length < utflen) {
                reader.bytearr = new byte[utflen * 2];
                reader.chararr = new char[utflen * 2];
            }
            bytearr = reader.bytearr;
            chararr = reader.chararr;
        }
        int chararr_count = 0;
        in.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararr_count);
    }

    public static void writeUTF8(CharSequence str, DataOutput out) throws IOException {
        UTF8StringUtil.writeUTF8(str, out, null);
    }

    public static void writeUTF8(CharSequence str, DataOutput out, UTF8StringWriter writer) throws IOException {
        int i;
        char c;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        for (int i2 = 0; i2 < strlen; ++i2) {
            c = str.charAt(i2);
            utflen += UTF8StringUtil.getModifiedUTF8Len(c);
        }
        byte[] tempBytes = UTF8StringUtil.getTempBytes(writer, utflen);
        count += VarLenIntEncoderDecoder.encode(utflen, tempBytes, count);
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            tempBytes[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            count += UTF8StringUtil.writeToBytes(tempBytes, count, c);
            ++i;
        }
        out.write(tempBytes, 0, count);
    }

    static void writeUTF8(char[] buffer, int start, int length, DataOutput out, UTF8StringWriter writer) throws IOException {
        int i;
        char c;
        int utflen = 0;
        int count = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            c = buffer[i2 + start];
            utflen += UTF8StringUtil.getModifiedUTF8Len(c);
        }
        byte[] tempBytes = UTF8StringUtil.getTempBytes(writer, utflen);
        count += VarLenIntEncoderDecoder.encode(utflen, tempBytes, count);
        for (i = 0; i < length && (c = buffer[i + start]) >= '\u0001' && c <= '\u007f'; ++i) {
            tempBytes[count++] = (byte)c;
        }
        while (i < length) {
            c = buffer[i + start];
            count += UTF8StringUtil.writeToBytes(tempBytes, count, c);
            ++i;
        }
        out.write(tempBytes, 0, count);
    }

    private static int writeToBytes(byte[] tempBytes, int count, char c) {
        int orig = count;
        if (c >= '\u0001' && c <= '\u007f') {
            tempBytes[count++] = (byte)c;
        } else if (c > '\u07ff') {
            tempBytes[count++] = (byte)(0xE0 | c >> 12 & 0xF);
            tempBytes[count++] = (byte)(0x80 | c >> 6 & 0x3F);
            tempBytes[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        } else {
            tempBytes[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            tempBytes[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return count - orig;
    }

    private static byte[] getTempBytes(UTF8StringWriter writer, int utflen) {
        byte[] tempBytes;
        if (writer == null) {
            tempBytes = new byte[utflen + 5];
        } else {
            if (writer.tempBytes == null || writer.tempBytes.length < utflen + 5) {
                writer.tempBytes = new byte[utflen + 5];
            }
            tempBytes = writer.tempBytes;
        }
        return tempBytes;
    }
}

