/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.context.Scope;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;

public class SqlppSubstituteExpressionVisitor
extends AbstractSqlppExpressionScopingVisitor {
    private final Map<Expression, Expression> exprMap = new HashMap<Expression, Expression>();

    public SqlppSubstituteExpressionVisitor(LangRewritingContext context, Map<Expression, Expression> exprMap) {
        super(context);
        this.exprMap.putAll(exprMap);
    }

    @Override
    protected Expression preVisit(Expression expr) throws CompilationException {
        Expression mappedExpr = this.exprMap.get(expr);
        if (mappedExpr == null) {
            return expr;
        }
        Collection<VariableExpr> freeVars = SqlppVariableUtil.getFreeVariables((ILangExpression)expr);
        for (VariableExpr freeVar : freeVars) {
            Scope currentScope = this.scopeChecker.getCurrentScope();
            if (currentScope.findSymbol(freeVar.getVar().getValue()) == null) continue;
            return expr;
        }
        return (Expression)SqlppRewriteUtil.deepCopy((ILangExpression)mappedExpr);
    }
}

