/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor;

import java.io.PrintWriter;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.visitor.FormatPrintVisitor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;

public class SqlppFormatPrintVisitor
extends FormatPrintVisitor
implements ISqlppVisitor<Void, Integer> {
    public SqlppFormatPrintVisitor(PrintWriter out) {
        super(out);
        this.dataverseSymbol = " database ";
        this.datasetSymbol = " table ";
        this.assignSymbol = "=";
    }

    @Override
    public Void visit(FromClause fromClause, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "from ");
        int index = 0;
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            if (index > 0) {
                this.out.print(",\n" + this.skip(step + 2));
            }
            fromTerm.accept(this, step + 2);
            ++index;
        }
        this.out.println();
        return null;
    }

    @Override
    public Void visit(FromTerm fromTerm, Integer step) throws CompilationException {
        fromTerm.getLeftExpression().accept((ILangVisitor)this, (Object)(step + 2));
        this.out.print(" as ");
        fromTerm.getLeftVariable().accept((ILangVisitor)this, (Object)(step + 2));
        if (fromTerm.hasPositionalVariable()) {
            this.out.print(" at ");
            fromTerm.getPositionalVariable().accept((ILangVisitor)this, (Object)(step + 2));
        }
        if (fromTerm.hasCorrelateClauses()) {
            for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
                correlateClause.accept(this, step);
            }
        }
        return null;
    }

    @Override
    public Void visit(JoinClause joinClause, Integer step) throws CompilationException {
        this.out.print((Object)joinClause.getJoinType());
        joinClause.getRightExpression().accept((ILangVisitor)this, (Object)(step + 2));
        this.out.print(" as ");
        joinClause.getRightVariable().accept((ILangVisitor)this, (Object)(step + 2));
        if (joinClause.hasPositionalVariable()) {
            this.out.print(" at ");
            joinClause.getPositionalVariable().accept((ILangVisitor)this, (Object)(step + 2));
        }
        joinClause.getConditionExpression().accept((ILangVisitor)this, (Object)(step + 2));
        return null;
    }

    @Override
    public Void visit(NestClause nestClause, Integer step) throws CompilationException {
        this.out.print((Object)nestClause.getJoinType());
        nestClause.getRightExpression().accept((ILangVisitor)this, (Object)(step + 2));
        this.out.println(this.skip(step + 1) + " as ");
        nestClause.getRightVariable().accept((ILangVisitor)this, (Object)(step + 2));
        if (nestClause.hasPositionalVariable()) {
            this.out.println(this.skip(step + 1) + " at ");
            nestClause.getPositionalVariable().accept((ILangVisitor)this, (Object)(step + 2));
        }
        nestClause.getConditionExpression().accept((ILangVisitor)this, (Object)(step + 2));
        return null;
    }

    @Override
    public Void visit(Projection projection, Integer step) throws CompilationException {
        if (projection.star()) {
            this.out.print(" * ");
            return null;
        }
        projection.getExpression().accept((ILangVisitor)this, (Object)step);
        if (projection.varStar()) {
            this.out.print(".* ");
        } else {
            String name = projection.getName();
            if (name != null) {
                this.out.print(" as " + name);
            }
        }
        return null;
    }

    @Override
    public Void visit(SelectBlock selectBlock, Integer step) throws CompilationException {
        selectBlock.getSelectClause().accept(this, step);
        if (selectBlock.hasFromClause()) {
            selectBlock.getFromClause().accept(this, step);
        }
        if (selectBlock.hasLetClauses()) {
            for (LetClause letClause : selectBlock.getLetList()) {
                letClause.accept((ILangVisitor)this, (Object)step);
            }
        }
        if (selectBlock.hasWhereClause()) {
            selectBlock.getWhereClause().accept((ILangVisitor)this, (Object)step);
        }
        if (selectBlock.hasGroupbyClause()) {
            selectBlock.getGroupbyClause().accept((ILangVisitor)this, (Object)step);
            if (selectBlock.hasLetClausesAfterGroupby()) {
                for (LetClause letClause : selectBlock.getLetListAfterGroupby()) {
                    letClause.accept((ILangVisitor)this, (Object)step);
                }
            }
        }
        if (selectBlock.hasHavingClause()) {
            selectBlock.getHavingClause().accept(this, step);
        }
        return null;
    }

    @Override
    public Void visit(SelectClause selectClause, Integer step) throws CompilationException {
        if (selectClause.selectRegular()) {
            selectClause.getSelectRegular().accept(this, step);
        }
        if (selectClause.selectElement()) {
            selectClause.getSelectElement().accept(this, step);
        }
        this.out.println();
        return null;
    }

    @Override
    public Void visit(SelectElement selectElement, Integer step) throws CompilationException {
        this.out.print("select element ");
        selectElement.getExpression().accept((ILangVisitor)this, (Object)step);
        return null;
    }

    @Override
    public Void visit(SelectRegular selectRegular, Integer step) throws CompilationException {
        this.out.print("select ");
        int index = 0;
        for (Projection projection : selectRegular.getProjections()) {
            if (index > 0) {
                this.out.print(",");
            }
            projection.accept(this, step);
            ++index;
        }
        return null;
    }

    @Override
    public Void visit(SelectSetOperation selectSetOperation, Integer step) throws CompilationException {
        selectSetOperation.getLeftInput().accept(this, step);
        if (selectSetOperation.hasRightInputs()) {
            for (SetOperationRight right : selectSetOperation.getRightInputs()) {
                String all = right.isSetSemantics() ? " " : " all ";
                this.out.print((Object)((Object)right.getSetOpType()) + all);
                right.getSetOperationRightInput().accept(this, step);
            }
        }
        return null;
    }

    @Override
    public Void visit(SelectExpression selectStatement, Integer step) throws CompilationException {
        int selectStep;
        if (selectStatement.isSubquery()) {
            this.out.print("(");
        }
        int n = selectStep = selectStatement.isSubquery() ? step + 2 : step;
        if (selectStatement.hasLetClauses()) {
            for (LetClause letClause : selectStatement.getLetList()) {
                letClause.accept((ILangVisitor)this, (Object)selectStep);
            }
        }
        selectStatement.getSelectSetOperation().accept(this, selectStep);
        if (selectStatement.hasOrderby()) {
            selectStatement.getOrderbyClause().accept((ILangVisitor)this, (Object)selectStep);
        }
        if (selectStatement.hasLimit()) {
            selectStatement.getLimitClause().accept((ILangVisitor)this, (Object)selectStep);
        }
        if (selectStatement.isSubquery()) {
            this.out.print(this.skip(step) + " )");
        }
        return null;
    }

    @Override
    public Void visit(UnnestClause unnestClause, Integer step) throws CompilationException {
        this.out.print((Object)unnestClause.getJoinType());
        unnestClause.getRightExpression().accept((ILangVisitor)this, (Object)(step + 2));
        this.out.print(" as ");
        unnestClause.getRightVariable().accept((ILangVisitor)this, (Object)(step + 2));
        if (unnestClause.hasPositionalVariable()) {
            this.out.print(" at ");
            unnestClause.getPositionalVariable().accept((ILangVisitor)this, (Object)(step + 2));
        }
        return null;
    }

    @Override
    public Void visit(HavingClause havingClause, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + " having ");
        havingClause.getFilterExpression().accept((ILangVisitor)this, (Object)(step + 2));
        this.out.println();
        return null;
    }

    public Void visit(GroupbyClause gc, Integer step) throws CompilationException {
        if (gc.hasHashGroupByHint()) {
            this.out.println(this.skip(step) + "/* +hash */");
        }
        this.out.print(this.skip(step) + "group by ");
        this.printDelimitedGbyExpressions(gc.getGbyPairList(), step + 2);
        this.out.println();
        return null;
    }

    public Void visit(InsertStatement insert, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "insert into " + this.datasetSymbol + this.generateFullName(insert.getDataverseName(), insert.getDatasetName()) + "\n");
        insert.getQuery().accept((ILangVisitor)this, (Object)step);
        this.out.println(";");
        return null;
    }

    public Void visit(LetClause lc, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "with ");
        Expression bindingExpr = lc.getBindingExpr();
        bindingExpr.accept((ILangVisitor)this, (Object)(step + 2));
        this.out.print(" as ");
        lc.getVarExpr().accept((ILangVisitor)this, (Object)(step + 2));
        this.out.println();
        return null;
    }

    protected void printDelimitedGbyExpressions(List<GbyVariableExpressionPair> gbyList, int step) throws CompilationException {
        int gbySize = gbyList.size();
        int gbyIndex = 0;
        for (GbyVariableExpressionPair pair : gbyList) {
            pair.getExpr().accept((ILangVisitor)this, (Object)step);
            if (pair.getVar() != null) {
                this.out.print(" as ");
                pair.getVar().accept((ILangVisitor)this, (Object)step);
            }
            if (++gbyIndex >= gbySize) continue;
            this.out.print(",");
        }
    }

    @Override
    public Void visit(CaseExpression caseExpr, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "case ");
        caseExpr.getConditionExpr().accept((ILangVisitor)this, (Object)(step + 2));
        this.out.println();
        List<Expression> whenExprs = caseExpr.getWhenExprs();
        List<Expression> thenExprs = caseExpr.getThenExprs();
        for (int index = 0; index < whenExprs.size(); ++index) {
            this.out.print(this.skip(step) + "when ");
            whenExprs.get(index).accept((ILangVisitor)this, (Object)(step + 2));
            this.out.print(" then ");
            thenExprs.get(index).accept((ILangVisitor)this, (Object)(step + 2));
            this.out.println();
        }
        this.out.print(this.skip(step) + "else ");
        caseExpr.getElseExpr().accept((ILangVisitor)this, (Object)(step + 2));
        this.out.println();
        this.out.println(this.skip(step) + "end");
        return null;
    }

    public Void visit(VariableExpr v, Integer step) {
        this.out.print(SqlppVariableUtil.toUserDefinedName(v.getVar().getValue()));
        return null;
    }
}

