/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.IfExpr;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppQueryExpressionVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class DeepCopyVisitor
extends AbstractSqlppQueryExpressionVisitor<ILangExpression, Void> {
    @Override
    public FromClause visit(FromClause fromClause, Void arg) throws CompilationException {
        ArrayList<FromTerm> fromTerms = new ArrayList<FromTerm>();
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            fromTerms.add((FromTerm)fromTerm.accept(this, arg));
        }
        return new FromClause(fromTerms);
    }

    @Override
    public FromTerm visit(FromTerm fromTerm, Void arg) throws CompilationException {
        Expression fromExpr = (Expression)fromTerm.getLeftExpression().accept((ILangVisitor)this, (Object)arg);
        VariableExpr fromVar = (VariableExpr)fromTerm.getLeftVariable().accept((ILangVisitor)this, (Object)arg);
        VariableExpr positionVar = fromTerm.getPositionalVariable() == null ? null : (VariableExpr)fromTerm.getPositionalVariable().accept((ILangVisitor)this, (Object)arg);
        ArrayList<AbstractBinaryCorrelateClause> correlateClauses = new ArrayList<AbstractBinaryCorrelateClause>();
        for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
            correlateClauses.add((AbstractBinaryCorrelateClause)correlateClause.accept(this, arg));
        }
        return new FromTerm(fromExpr, fromVar, positionVar, correlateClauses);
    }

    @Override
    public JoinClause visit(JoinClause joinClause, Void arg) throws CompilationException {
        Expression rightExpression = (Expression)joinClause.getRightExpression().accept((ILangVisitor)this, (Object)arg);
        VariableExpr rightVar = (VariableExpr)joinClause.getRightVariable().accept((ILangVisitor)this, (Object)arg);
        VariableExpr rightPositionVar = joinClause.getPositionalVariable() == null ? null : (VariableExpr)joinClause.getPositionalVariable().accept((ILangVisitor)this, (Object)arg);
        Expression conditionExpresion = (Expression)joinClause.getConditionExpression().accept((ILangVisitor)this, (Object)arg);
        return new JoinClause(joinClause.getJoinType(), rightExpression, rightVar, rightPositionVar, conditionExpresion);
    }

    @Override
    public NestClause visit(NestClause nestClause, Void arg) throws CompilationException {
        Expression rightExpression = (Expression)nestClause.getRightExpression().accept((ILangVisitor)this, (Object)arg);
        VariableExpr rightVar = (VariableExpr)nestClause.getRightVariable().accept((ILangVisitor)this, (Object)arg);
        VariableExpr rightPositionVar = nestClause.getPositionalVariable() == null ? null : (VariableExpr)nestClause.getPositionalVariable().accept((ILangVisitor)this, (Object)arg);
        Expression conditionExpresion = (Expression)nestClause.getConditionExpression().accept((ILangVisitor)this, (Object)arg);
        return new NestClause(nestClause.getJoinType(), rightExpression, rightVar, rightPositionVar, conditionExpresion);
    }

    @Override
    public UnnestClause visit(UnnestClause unnestClause, Void arg) throws CompilationException {
        Expression rightExpression = (Expression)unnestClause.getRightExpression().accept((ILangVisitor)this, (Object)arg);
        VariableExpr rightVar = (VariableExpr)unnestClause.getRightVariable().accept((ILangVisitor)this, (Object)arg);
        VariableExpr rightPositionVar = unnestClause.getPositionalVariable() == null ? null : (VariableExpr)unnestClause.getPositionalVariable().accept((ILangVisitor)this, (Object)arg);
        return new UnnestClause(unnestClause.getJoinType(), rightExpression, rightVar, rightPositionVar);
    }

    @Override
    public Projection visit(Projection projection, Void arg) throws CompilationException {
        return new Projection(projection.star() ? null : (Expression)projection.getExpression().accept((ILangVisitor)this, (Object)arg), projection.getName(), projection.star(), projection.varStar());
    }

    @Override
    public SelectBlock visit(SelectBlock selectBlock, Void arg) throws CompilationException {
        FromClause fromClause = null;
        ArrayList<LetClause> letClauses = new ArrayList<LetClause>();
        WhereClause whereClause = null;
        GroupbyClause gbyClause = null;
        ArrayList<LetClause> gbyLetClauses = new ArrayList<LetClause>();
        HavingClause havingClause = null;
        if (selectBlock.hasFromClause()) {
            fromClause = (FromClause)selectBlock.getFromClause().accept(this, arg);
        }
        if (selectBlock.hasLetClauses()) {
            List<LetClause> letList = selectBlock.getLetList();
            for (LetClause letClause : letList) {
                letClauses.add((LetClause)letClause.accept((ILangVisitor)this, (Object)arg));
            }
        }
        if (selectBlock.hasWhereClause()) {
            whereClause = (WhereClause)selectBlock.getWhereClause().accept((ILangVisitor)this, (Object)arg);
        }
        if (selectBlock.hasGroupbyClause()) {
            gbyClause = (GroupbyClause)selectBlock.getGroupbyClause().accept((ILangVisitor)this, (Object)arg);
        }
        if (selectBlock.hasLetClausesAfterGroupby()) {
            List<LetClause> letListAfterGby = selectBlock.getLetListAfterGroupby();
            for (LetClause letClauseAfterGby : letListAfterGby) {
                gbyLetClauses.add((LetClause)letClauseAfterGby.accept((ILangVisitor)this, (Object)arg));
            }
        }
        if (selectBlock.hasHavingClause()) {
            havingClause = (HavingClause)selectBlock.getHavingClause().accept(this, arg);
        }
        SelectClause selectCluase = (SelectClause)selectBlock.getSelectClause().accept(this, arg);
        return new SelectBlock(selectCluase, fromClause, letClauses, whereClause, gbyClause, gbyLetClauses, havingClause);
    }

    @Override
    public SelectClause visit(SelectClause selectClause, Void arg) throws CompilationException {
        SelectElement selectElement = null;
        SelectRegular selectRegular = null;
        if (selectClause.selectElement()) {
            selectElement = (SelectElement)selectClause.getSelectElement().accept(this, arg);
        }
        if (selectClause.selectRegular()) {
            selectRegular = (SelectRegular)selectClause.getSelectRegular().accept(this, arg);
        }
        return new SelectClause(selectElement, selectRegular, selectClause.distinct());
    }

    @Override
    public SelectElement visit(SelectElement selectElement, Void arg) throws CompilationException {
        return new SelectElement((Expression)selectElement.getExpression().accept((ILangVisitor)this, (Object)arg));
    }

    @Override
    public SelectRegular visit(SelectRegular selectRegular, Void arg) throws CompilationException {
        ArrayList<Projection> projections = new ArrayList<Projection>();
        for (Projection projection : selectRegular.getProjections()) {
            projections.add((Projection)projection.accept(this, arg));
        }
        return new SelectRegular(projections);
    }

    @Override
    public SelectSetOperation visit(SelectSetOperation selectSetOperation, Void arg) throws CompilationException {
        SetOperationInput leftInput = selectSetOperation.getLeftInput();
        SetOperationInput newLeftInput = leftInput.selectBlock() ? new SetOperationInput((SelectBlock)leftInput.accept(this, arg), null) : new SetOperationInput(null, (SelectExpression)leftInput.accept(this, arg));
        ArrayList<SetOperationRight> rightInputs = new ArrayList<SetOperationRight>();
        for (SetOperationRight right : selectSetOperation.getRightInputs()) {
            SetOperationInput setOpRightInput = right.getSetOperationRightInput();
            SetOperationInput newRightInput = setOpRightInput.selectBlock() ? new SetOperationInput((SelectBlock)setOpRightInput.accept(this, arg), null) : new SetOperationInput(null, (SelectExpression)setOpRightInput.accept(this, arg));
            rightInputs.add(new SetOperationRight(right.getSetOpType(), right.isSetSemantics(), newRightInput));
        }
        return new SelectSetOperation(newLeftInput, rightInputs);
    }

    @Override
    public HavingClause visit(HavingClause havingClause, Void arg) throws CompilationException {
        return new HavingClause((Expression)havingClause.getFilterExpression().accept((ILangVisitor)this, (Object)arg));
    }

    public Query visit(Query q, Void arg) throws CompilationException {
        return new Query(q.isExplain(), q.isTopLevel(), (Expression)q.getBody().accept((ILangVisitor)this, (Object)arg), q.getVarCounter(), q.getExternalVars());
    }

    public FunctionDecl visit(FunctionDecl fd, Void arg) throws CompilationException {
        return new FunctionDecl(fd.getSignature(), fd.getParamList(), (Expression)fd.getFuncBody().accept((ILangVisitor)this, (Object)arg));
    }

    public WhereClause visit(WhereClause whereClause, Void arg) throws CompilationException {
        return new WhereClause((Expression)whereClause.getWhereExpr().accept((ILangVisitor)this, (Object)arg));
    }

    public OrderbyClause visit(OrderbyClause oc, Void arg) throws CompilationException {
        ArrayList<Expression> newOrderbyList = new ArrayList<Expression>();
        for (Expression orderExpr : oc.getOrderbyList()) {
            newOrderbyList.add((Expression)orderExpr.accept((ILangVisitor)this, (Object)arg));
        }
        return new OrderbyClause(newOrderbyList, oc.getModifierList());
    }

    public GroupbyClause visit(GroupbyClause gc, Void arg) throws CompilationException {
        VariableExpr var;
        ArrayList<GbyVariableExpressionPair> gbyPairList = new ArrayList<GbyVariableExpressionPair>();
        ArrayList<GbyVariableExpressionPair> decorPairList = new ArrayList<GbyVariableExpressionPair>();
        HashMap<Expression, VariableExpr> withVarMap = new HashMap<Expression, VariableExpr>();
        VariableExpr groupVarExpr = null;
        ArrayList<Pair> groupFieldList = new ArrayList<Pair>();
        for (GbyVariableExpressionPair gbyVariableExpressionPair : gc.getGbyPairList()) {
            var = gbyVariableExpressionPair.getVar();
            gbyPairList.add(new GbyVariableExpressionPair(var == null ? null : (VariableExpr)var.accept((ILangVisitor)this, (Object)arg), (Expression)gbyVariableExpressionPair.getExpr().accept((ILangVisitor)this, (Object)arg)));
        }
        for (GbyVariableExpressionPair gbyVariableExpressionPair : gc.getDecorPairList()) {
            var = gbyVariableExpressionPair.getVar();
            decorPairList.add(new GbyVariableExpressionPair(var == null ? null : (VariableExpr)var.accept((ILangVisitor)this, (Object)arg), (Expression)gbyVariableExpressionPair.getExpr().accept((ILangVisitor)this, (Object)arg)));
        }
        for (Map.Entry entry : gc.getWithVarMap().entrySet()) {
            withVarMap.put((Expression)((Expression)entry.getKey()).accept((ILangVisitor)this, (Object)arg), (VariableExpr)((VariableExpr)entry.getValue()).accept((ILangVisitor)this, (Object)arg));
        }
        if (gc.hasGroupVar()) {
            groupVarExpr = (VariableExpr)gc.getGroupVar().accept((ILangVisitor)this, (Object)arg);
        }
        for (Pair pair : gc.getGroupFieldList()) {
            groupFieldList.add(new Pair((Object)((Expression)((Expression)pair.first).accept((ILangVisitor)this, (Object)arg)), pair.second));
        }
        return new GroupbyClause(gbyPairList, decorPairList, withVarMap, groupVarExpr, groupFieldList, gc.hasHashGroupByHint(), gc.isGroupAll());
    }

    public LimitClause visit(LimitClause limitClause, Void arg) throws CompilationException {
        Expression limitExpr = (Expression)limitClause.getLimitExpr().accept((ILangVisitor)this, (Object)arg);
        Expression offsetExpr = limitClause.hasOffset() ? (Expression)limitClause.getOffset().accept((ILangVisitor)this, (Object)arg) : null;
        return new LimitClause(limitExpr, offsetExpr);
    }

    public LetClause visit(LetClause letClause, Void arg) throws CompilationException {
        return new LetClause((VariableExpr)letClause.getVarExpr().accept((ILangVisitor)this, (Object)arg), (Expression)letClause.getBindingExpr().accept((ILangVisitor)this, (Object)arg));
    }

    @Override
    public SelectExpression visit(SelectExpression selectExpression, Void arg) throws CompilationException {
        ArrayList<LetClause> lets = new ArrayList<LetClause>();
        OrderbyClause orderby = null;
        LimitClause limit = null;
        if (selectExpression.hasLetClauses()) {
            for (LetClause letClause : selectExpression.getLetList()) {
                lets.add((LetClause)letClause.accept((ILangVisitor)this, (Object)arg));
            }
        }
        SelectSetOperation select = (SelectSetOperation)selectExpression.getSelectSetOperation().accept(this, arg);
        if (selectExpression.hasOrderby()) {
            ArrayList<Expression> orderExprs = new ArrayList<Expression>();
            for (Expression orderExpr : selectExpression.getOrderbyClause().getOrderbyList()) {
                orderExprs.add((Expression)orderExpr.accept((ILangVisitor)this, (Object)arg));
            }
            orderby = new OrderbyClause(orderExprs, selectExpression.getOrderbyClause().getModifierList());
        }
        if (selectExpression.hasLimit()) {
            limit = (LimitClause)selectExpression.getLimitClause().accept((ILangVisitor)this, (Object)arg);
        }
        return new SelectExpression(lets, select, orderby, limit, selectExpression.isSubquery());
    }

    public LiteralExpr visit(LiteralExpr l, Void arg) throws CompilationException {
        return l;
    }

    public ListConstructor visit(ListConstructor lc, Void arg) throws CompilationException {
        return new ListConstructor(lc.getType(), this.copyExprList(lc.getExprList(), arg));
    }

    public RecordConstructor visit(RecordConstructor rc, Void arg) throws CompilationException {
        ArrayList<FieldBinding> bindings = new ArrayList<FieldBinding>();
        for (FieldBinding binding : rc.getFbList()) {
            FieldBinding fb = new FieldBinding((Expression)binding.getLeftExpr().accept((ILangVisitor)this, (Object)arg), (Expression)binding.getRightExpr().accept((ILangVisitor)this, (Object)arg));
            bindings.add(fb);
        }
        return new RecordConstructor(bindings);
    }

    public OperatorExpr visit(OperatorExpr operatorExpr, Void arg) throws CompilationException {
        return new OperatorExpr(this.copyExprList(operatorExpr.getExprList(), arg), operatorExpr.getExprBroadcastIdx(), operatorExpr.getOpList(), operatorExpr.isCurrentop());
    }

    public IfExpr visit(IfExpr ifExpr, Void arg) throws CompilationException {
        Expression conditionExpr = (Expression)ifExpr.getCondExpr().accept((ILangVisitor)this, (Object)arg);
        Expression thenExpr = (Expression)ifExpr.getThenExpr().accept((ILangVisitor)this, (Object)arg);
        Expression elseExpr = (Expression)ifExpr.getElseExpr().accept((ILangVisitor)this, (Object)arg);
        return new IfExpr(conditionExpr, thenExpr, elseExpr);
    }

    public QuantifiedExpression visit(QuantifiedExpression qe, Void arg) throws CompilationException {
        ArrayList<QuantifiedPair> quantifiedPairs = new ArrayList<QuantifiedPair>();
        for (QuantifiedPair pair : qe.getQuantifiedList()) {
            Expression expr = (Expression)pair.getExpr().accept((ILangVisitor)this, (Object)arg);
            VariableExpr var = (VariableExpr)pair.getVarExpr().accept((ILangVisitor)this, (Object)arg);
            quantifiedPairs.add(new QuantifiedPair(var, expr));
        }
        Expression condition = (Expression)qe.getSatisfiesExpr().accept((ILangVisitor)this, (Object)arg);
        return new QuantifiedExpression(qe.getQuantifier(), quantifiedPairs, condition);
    }

    public CallExpr visit(CallExpr callExpr, Void arg) throws CompilationException {
        ArrayList<Expression> newExprList = new ArrayList<Expression>();
        for (Expression expr : callExpr.getExprList()) {
            newExprList.add((Expression)expr.accept((ILangVisitor)this, (Object)arg));
        }
        return new CallExpr(callExpr.getFunctionSignature(), newExprList);
    }

    public VariableExpr visit(VariableExpr varExpr, Void arg) throws CompilationException {
        VariableExpr clonedVar = new VariableExpr(new VarIdentifier(varExpr.getVar()));
        clonedVar.setIsNewVar(varExpr.getIsNewVar());
        return clonedVar;
    }

    public UnaryExpr visit(UnaryExpr u, Void arg) throws CompilationException {
        return new UnaryExpr(u.getExprType(), (Expression)u.getExpr().accept((ILangVisitor)this, (Object)arg));
    }

    public FieldAccessor visit(FieldAccessor fa, Void arg) throws CompilationException {
        return new FieldAccessor((Expression)fa.getExpr().accept((ILangVisitor)this, (Object)arg), fa.getIdent());
    }

    public Expression visit(IndexAccessor ia, Void arg) throws CompilationException {
        Expression expr = (Expression)ia.getExpr().accept((ILangVisitor)this, (Object)arg);
        Expression indexExpr = null;
        if (ia.getIndexExpr() != null) {
            indexExpr = (Expression)ia.getIndexExpr().accept((ILangVisitor)this, (Object)arg);
        }
        return new IndexAccessor(expr, indexExpr);
    }

    @Override
    public ILangExpression visit(CaseExpression caseExpr, Void arg) throws CompilationException {
        Expression conditionExpr = (Expression)caseExpr.getConditionExpr().accept((ILangVisitor)this, (Object)arg);
        List<Expression> whenExprList = this.copyExprList(caseExpr.getWhenExprs(), arg);
        List<Expression> thenExprList = this.copyExprList(caseExpr.getThenExprs(), arg);
        Expression elseExpr = (Expression)caseExpr.getElseExpr().accept((ILangVisitor)this, (Object)arg);
        return new CaseExpression(conditionExpr, whenExprList, thenExprList, elseExpr);
    }

    private List<Expression> copyExprList(List<Expression> exprs, Void arg) throws CompilationException {
        ArrayList<Expression> newExprList = new ArrayList<Expression>();
        for (Expression expr : exprs) {
            newExprList.add((Expression)expr.accept((ILangVisitor)this, (Object)arg));
        }
        return newExprList;
    }
}

