/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.CheckDatasetOnlyResolutionVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class VariableCheckAndRewriteVisitor
extends AbstractSqlppExpressionScopingVisitor {
    private static final FunctionSignature FN_DATASET = new FunctionSignature(BuiltinFunctions.DATASET);
    protected final MetadataProvider metadataProvider;

    public VariableCheckAndRewriteVisitor(LangRewritingContext context, MetadataProvider metadataProvider, List<VarIdentifier> externalVars) {
        super(context, externalVars);
        this.metadataProvider = metadataProvider;
    }

    @Override
    public Expression visit(FieldAccessor fa, ILangExpression parent) throws CompilationException {
        CallExpr callExpr;
        Expression leadingExpr = fa.getExpr();
        if (leadingExpr.getKind() != Expression.Kind.VARIABLE_EXPRESSION) {
            fa.setExpr((Expression)leadingExpr.accept((ILangVisitor)this, (Object)fa));
            return fa;
        }
        VariableExpr varExpr = (VariableExpr)leadingExpr;
        String lastIdentifier = fa.getIdent().getValue();
        Expression resolvedExpr = this.resolve(varExpr, SqlppVariableUtil.toUserDefinedVariableName(varExpr.getVar().getValue()).getValue(), lastIdentifier, (Expression)fa, parent);
        if (resolvedExpr.getKind() == Expression.Kind.CALL_EXPRESSION && (callExpr = (CallExpr)resolvedExpr).getFunctionSignature().equals((Object)FN_DATASET)) {
            return resolvedExpr;
        }
        fa.setExpr(resolvedExpr);
        return fa;
    }

    @Override
    public Expression visit(VariableExpr varExpr, ILangExpression parent) throws CompilationException {
        return this.resolve(varExpr, this.metadataProvider.getDefaultDataverseName(), SqlppVariableUtil.toUserDefinedVariableName(varExpr.getVar().getValue()).getValue(), (Expression)varExpr, parent);
    }

    private Expression resolve(VariableExpr varExpr, String dataverseName, String datasetName, Expression originalExprWithUndefinedIdentifier, ILangExpression parent) throws CompilationException {
        String varName = varExpr.getVar().getValue();
        VarIdentifier var = this.lookupVariable(varName);
        if (var != null) {
            varExpr.setIsNewVar(false);
            varExpr.setVar(var);
            return varExpr;
        }
        boolean resolveToDatasetOnly = this.resolveToDatasetOnly(originalExprWithUndefinedIdentifier, parent);
        if (resolveToDatasetOnly) {
            return this.resolveAsDataset(dataverseName, datasetName);
        }
        Set localVars = this.scopeChecker.getCurrentScope().getLiveVariables(this.scopeChecker.getPrecedingScope());
        switch (localVars.size()) {
            case 0: {
                return this.resolveAsDataset(dataverseName, datasetName);
            }
            case 1: {
                return this.resolveAsFieldAccess((VariableExpr)localVars.iterator().next(), SqlppVariableUtil.toUserDefinedVariableName(varName).getValue());
            }
        }
        throw new CompilationException("Cannot resolve ambiguous alias reference for undefined identifier " + SqlppVariableUtil.toUserDefinedVariableName(varName).getValue() + " in " + localVars);
    }

    private VarIdentifier lookupVariable(String varName) throws CompilationException {
        if (this.scopeChecker.isInForbiddenScopes(varName)) {
            throw new CompilationException("Inside limit clauses, it is disallowed to reference a variable having the same name as any variable bound in the same scope as the limit clause.");
        }
        Identifier ident = this.scopeChecker.lookupSymbol(varName);
        return ident != null ? (VarIdentifier)ident : null;
    }

    private Expression resolveAsDataset(String dataverseName, String datasetName) throws CompilationException {
        if (!this.datasetExists(dataverseName, datasetName)) {
            this.throwUnresolvableError(dataverseName, datasetName);
        }
        String fullyQualifiedName = dataverseName == null ? datasetName : dataverseName + "." + datasetName;
        ArrayList<LiteralExpr> argList = new ArrayList<LiteralExpr>(1);
        argList.add(new LiteralExpr((Literal)new StringLiteral(fullyQualifiedName)));
        return new CallExpr(new FunctionSignature(BuiltinFunctions.DATASET), argList);
    }

    private Expression resolveAsFieldAccess(VariableExpr var, String fieldName) throws CompilationException {
        ArrayList<Object> argList = new ArrayList<Object>(2);
        argList.add(var);
        argList.add(new LiteralExpr((Literal)new StringLiteral(fieldName)));
        return new CallExpr(new FunctionSignature(BuiltinFunctions.FIELD_ACCESS_BY_NAME), argList);
    }

    private void throwUnresolvableError(String dataverseName, String datasetName) throws CompilationException {
        String defaultDataverseName = this.metadataProvider.getDefaultDataverseName();
        if (dataverseName == null && defaultDataverseName == null) {
            throw new CompilationException("Cannot find dataset " + datasetName + " because there is no dataverse declared, nor an alias with name " + datasetName + "!");
        }
        throw new CompilationException("Cannot find dataset " + datasetName + " in dataverse " + (dataverseName == null ? defaultDataverseName : dataverseName) + " nor an alias with name " + datasetName + "!");
    }

    private boolean resolveToDatasetOnly(Expression originalExpressionWithUndefinedIdentifier, ILangExpression parent) throws CompilationException {
        CheckDatasetOnlyResolutionVisitor visitor = new CheckDatasetOnlyResolutionVisitor();
        return (Boolean)parent.accept((ILangVisitor)visitor, (Object)originalExpressionWithUndefinedIdentifier);
    }

    private boolean datasetExists(String dataverseName, String datasetName) throws CompilationException {
        try {
            return this.metadataProvider.findDataset(dataverseName, datasetName) != null || this.fullyQualifiedDatasetNameExists(datasetName);
        }
        catch (AlgebricksException e) {
            throw new CompilationException((Throwable)e);
        }
    }

    private boolean fullyQualifiedDatasetNameExists(String name) throws AlgebricksException {
        if (name.indexOf(46) < 0) {
            return false;
        }
        String[] path = StringUtils.split((String)name, (char)'.');
        return path.length == 2 && this.metadataProvider.findDataset(path[0], path[1]) != null;
    }

    @Override
    public Expression visit(CallExpr callExpr, ILangExpression arg) throws CompilationException {
        if (FunctionMapUtil.isSql92AggregateFunction(callExpr.getFunctionSignature())) {
            return callExpr;
        }
        return super.visit(callExpr, arg);
    }
}

