/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppSimpleExpressionVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class SqlppGroupByAggregationSugarVisitor
extends AbstractSqlppExpressionScopingVisitor {
    public SqlppGroupByAggregationSugarVisitor(LangRewritingContext context) {
        super(context);
    }

    @Override
    public Expression visit(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        FromClause fromClause = selectBlock.getFromClause();
        if (selectBlock.hasFromClause()) {
            fromClause.accept(this, arg);
        }
        if (selectBlock.hasLetClauses()) {
            List<LetClause> letList = selectBlock.getLetList();
            for (LetClause letClause : letList) {
                letClause.accept((ILangVisitor)this, (Object)arg);
            }
        }
        if (selectBlock.hasWhereClause()) {
            selectBlock.getWhereClause().accept((ILangVisitor)this, (Object)arg);
        }
        if (selectBlock.hasGroupbyClause()) {
            SelectExpression parentSelectExpression;
            Set visibleVarsPreGroupByScope = this.scopeChecker.getCurrentScope().getLiveVariables();
            GroupbyClause groupbyClause = selectBlock.getGroupbyClause();
            groupbyClause.accept((ILangVisitor)this, (Object)arg);
            Collection<VariableExpr> visibleVarsInCurrentScope = SqlppVariableUtil.getBindingVariables(groupbyClause);
            VariableExpr groupVar = groupbyClause.getGroupVar();
            Map<Expression, Identifier> groupFieldVars = this.getGroupFieldVariables(groupbyClause);
            HashSet<VariableExpr> freeVariablesInGbyLets = new HashSet<VariableExpr>();
            if (selectBlock.hasLetClausesAfterGroupby()) {
                List<LetClause> letListAfterGby = selectBlock.getLetListAfterGroupby();
                for (LetClause letClauseAfterGby : letListAfterGby) {
                    letClauseAfterGby.accept((ILangVisitor)this, (Object)arg);
                    this.rewriteExpressionUsingGroupVariable(groupVar, groupFieldVars, (ILangExpression)letClauseAfterGby, visibleVarsPreGroupByScope);
                    Collection<VariableExpr> freeVariablesInLet = SqlppVariableUtil.getFreeVariables((ILangExpression)letClauseAfterGby.getBindingExpr());
                    freeVariablesInLet.removeAll(visibleVarsInCurrentScope);
                    freeVariablesInGbyLets.addAll(freeVariablesInLet);
                    visibleVarsInCurrentScope.add(letClauseAfterGby.getVarExpr());
                }
            }
            HashSet<VariableExpr> freeVariables = new HashSet<VariableExpr>();
            if (selectBlock.hasHavingClause()) {
                HavingClause havingClause = selectBlock.getHavingClause();
                havingClause.accept(this, arg);
                this.rewriteExpressionUsingGroupVariable(groupVar, groupFieldVars, (ILangExpression)havingClause, visibleVarsPreGroupByScope);
                freeVariables.addAll(SqlppVariableUtil.getFreeVariables((ILangExpression)havingClause));
            }
            if (!(parentSelectExpression = (SelectExpression)arg).getSelectSetOperation().hasRightInputs()) {
                if (parentSelectExpression.hasOrderby()) {
                    OrderbyClause orderbyClause = parentSelectExpression.getOrderbyClause();
                    orderbyClause.accept((ILangVisitor)this, (Object)arg);
                    this.rewriteExpressionUsingGroupVariable(groupVar, groupFieldVars, (ILangExpression)orderbyClause, visibleVarsPreGroupByScope);
                    freeVariables.addAll(SqlppVariableUtil.getFreeVariables((ILangExpression)orderbyClause));
                }
                if (parentSelectExpression.hasLimit()) {
                    LimitClause limitClause = parentSelectExpression.getLimitClause();
                    limitClause.accept((ILangVisitor)this, (Object)arg);
                    this.rewriteExpressionUsingGroupVariable(groupVar, groupFieldVars, (ILangExpression)limitClause, visibleVarsPreGroupByScope);
                    freeVariables.addAll(SqlppVariableUtil.getFreeVariables((ILangExpression)limitClause));
                }
            }
            SelectClause selectClause = selectBlock.getSelectClause();
            selectClause.accept(this, arg);
            this.rewriteExpressionUsingGroupVariable(groupVar, groupFieldVars, (ILangExpression)selectClause, visibleVarsPreGroupByScope);
            freeVariables.addAll(SqlppVariableUtil.getFreeVariables((ILangExpression)selectClause));
            freeVariables.removeAll(visibleVarsInCurrentScope);
            freeVariables.addAll(freeVariablesInGbyLets);
            Set decorVars = this.scopeChecker.getCurrentScope().getLiveVariables();
            decorVars.removeAll(visibleVarsInCurrentScope);
            if (!decorVars.containsAll(freeVariables)) {
                throw new IllegalStateException(decorVars + ":" + freeVariables);
            }
            decorVars.retainAll(freeVariables);
            if (!decorVars.isEmpty()) {
                ArrayList<GbyVariableExpressionPair> decorList = new ArrayList<GbyVariableExpressionPair>();
                for (VariableExpr var : decorVars) {
                    decorList.add(new GbyVariableExpressionPair((VariableExpr)SqlppRewriteUtil.deepCopy((ILangExpression)var), (Expression)SqlppRewriteUtil.deepCopy((ILangExpression)var)));
                }
                groupbyClause.getDecorPairList().addAll(decorList);
            }
        } else {
            selectBlock.getSelectClause().accept(this, arg);
        }
        return null;
    }

    private Map<Expression, Identifier> getGroupFieldVariables(GroupbyClause groupbyClause) {
        HashMap<Expression, Identifier> fieldVars = new HashMap<Expression, Identifier>();
        for (Pair groupField : groupbyClause.getGroupFieldList()) {
            fieldVars.put((Expression)groupField.first, (Identifier)groupField.second);
        }
        return fieldVars;
    }

    private void rewriteExpressionUsingGroupVariable(VariableExpr groupVar, Map<Expression, Identifier> fieldVars, ILangExpression expr, Set<VariableExpr> outerScopeVariables) throws CompilationException {
        Sql92AggregateFunctionVisitor visitor = new Sql92AggregateFunctionVisitor((Expression)groupVar, fieldVars, outerScopeVariables);
        expr.accept((ILangVisitor)visitor, null);
    }

    private final class Sql92AggregateFunctionVisitor
    extends AbstractSqlppSimpleExpressionVisitor {
        private final Expression groupVar;
        private final Map<Expression, Identifier> fieldVars;
        private final Collection<VariableExpr> outerVars;

        private Sql92AggregateFunctionVisitor(Expression groupVar, Map<Expression, Identifier> fieldVars, Collection<VariableExpr> outerVars) {
            this.groupVar = groupVar;
            this.fieldVars = fieldVars;
            this.outerVars = outerVars;
        }

        @Override
        public Expression visit(CallExpr callExpr, ILangExpression arg) throws CompilationException {
            ArrayList<Object> newExprList = new ArrayList<Object>();
            FunctionSignature signature = callExpr.getFunctionSignature();
            boolean aggregate = FunctionMapUtil.isSql92AggregateFunction(signature);
            boolean rewritten = false;
            for (Expression expr : callExpr.getExprList()) {
                Expression newExpr = aggregate ? this.wrapAggregationArgument(expr) : expr;
                rewritten |= newExpr != expr;
                newExprList.add(newExpr.accept((ILangVisitor)this, (Object)arg));
            }
            if (rewritten) {
                callExpr.setFunctionSignature(FunctionMapUtil.sql92ToCoreAggregateFunction(signature));
            }
            callExpr.setExprList(newExprList);
            return callExpr;
        }

        private Expression wrapAggregationArgument(Expression argExpr) throws CompilationException {
            Expression expr = argExpr;
            Set<VariableExpr> freeVars = SqlppRewriteUtil.getFreeVariable(expr);
            VariableExpr fromBindingVar = new VariableExpr(SqlppGroupByAggregationSugarVisitor.this.context.newVariable());
            FromTerm fromTerm = new FromTerm(this.groupVar, fromBindingVar, null, null);
            FromClause fromClause = new FromClause(Collections.singletonList(fromTerm));
            HashMap<Expression, Expression> varExprMap = new HashMap<Expression, Expression>();
            for (VariableExpr usedVar : freeVars) {
                if (this.fieldVars.containsKey(usedVar)) {
                    varExprMap.put((Expression)usedVar, (Expression)new FieldAccessor((Expression)fromBindingVar, (Identifier)new VarIdentifier(this.fieldVars.get(usedVar).getValue())));
                    continue;
                }
                if (this.outerVars.contains(usedVar)) continue;
                if (this.fieldVars.size() == 1) {
                    varExprMap.put((Expression)usedVar, (Expression)new FieldAccessor((Expression)new FieldAccessor((Expression)fromBindingVar, this.fieldVars.values().iterator().next()), (Identifier)SqlppVariableUtil.toUserDefinedVariableName(usedVar.getVar())));
                    continue;
                }
                throw new CompilationException("Cannot resolve alias reference for undefined identifier " + usedVar.getVar().getValue() + " in " + this.fieldVars);
            }
            SelectElement selectElement = new SelectElement(SqlppRewriteUtil.substituteExpression(expr, varExprMap, SqlppGroupByAggregationSugarVisitor.this.context));
            SelectClause selectClause = new SelectClause(selectElement, null, false);
            SelectBlock selectBlock = new SelectBlock(selectClause, fromClause, null, null, null, null, null);
            SelectSetOperation selectSetOperation = new SelectSetOperation(new SetOperationInput(selectBlock, null), null);
            return new SelectExpression(null, selectSetOperation, null, null, true);
        }
    }
}

