/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.literal.TrueLiteral;
import org.apache.asterix.lang.common.struct.OperatorType;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppSimpleExpressionVisitor;
import org.apache.asterix.om.functions.BuiltinFunctions;

public class SqlppBuiltinFunctionRewriteVisitor
extends AbstractSqlppSimpleExpressionVisitor {
    @Override
    public Expression visit(CallExpr callExpr, ILangExpression arg) throws CompilationException {
        FunctionSignature functionSignature = callExpr.getFunctionSignature();
        callExpr.setFunctionSignature(FunctionMapUtil.normalizeBuiltinFunctionSignature(functionSignature, true));
        ArrayList<Object> newExprList = new ArrayList<Object>();
        for (Expression expr : callExpr.getExprList()) {
            newExprList.add(expr.accept((ILangVisitor)this, (Object)arg));
        }
        callExpr.setExprList(newExprList);
        return callExpr;
    }

    @Override
    public Expression visit(CaseExpression caseExpr, ILangExpression arg) throws CompilationException {
        Expression expr = super.visit(caseExpr, arg);
        if (expr != caseExpr) {
            return (Expression)expr.accept((ILangVisitor)this, (Object)arg);
        }
        CaseExpression newCaseExpr = this.normalizeCaseExpr(caseExpr);
        if (SqlppRewriteUtil.constainsSubquery((ILangExpression)newCaseExpr)) {
            return newCaseExpr;
        }
        FunctionSignature functionSignature = new FunctionSignature(BuiltinFunctions.SWITCH_CASE);
        List<Expression> whenExprList = newCaseExpr.getWhenExprs();
        List<Expression> thenExprList = newCaseExpr.getThenExprs();
        ArrayList<Expression> newExprList = new ArrayList<Expression>();
        newExprList.add(newCaseExpr.getConditionExpr());
        for (int index = 0; index < whenExprList.size(); ++index) {
            newExprList.add(whenExprList.get(index));
            newExprList.add(thenExprList.get(index));
        }
        newExprList.add(newCaseExpr.getElseExpr());
        return new CallExpr(functionSignature, newExprList);
    }

    private CaseExpression normalizeCaseExpr(CaseExpression caseExpr) throws CompilationException {
        LiteralExpr trueLiteral = new LiteralExpr((Literal)TrueLiteral.INSTANCE);
        Expression conditionExpr = caseExpr.getConditionExpr();
        if (trueLiteral.equals((Object)conditionExpr)) {
            return caseExpr;
        }
        ArrayList<Expression> normalizedWhenExprs = new ArrayList<Expression>();
        for (Expression expr : caseExpr.getWhenExprs()) {
            OperatorExpr operatorExpr = new OperatorExpr();
            operatorExpr.addOperand((Expression)SqlppRewriteUtil.deepCopy((ILangExpression)expr));
            operatorExpr.addOperand(caseExpr.getConditionExpr());
            operatorExpr.addOperator(OperatorType.EQ);
            normalizedWhenExprs.add((Expression)operatorExpr);
        }
        return new CaseExpression((Expression)trueLiteral, normalizedWhenExprs, caseExpr.getThenExprs(), caseExpr.getElseExpr());
    }
}

