/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;

public class InlineWithExpressionVisitor
extends AbstractSqlppExpressionScopingVisitor {
    public InlineWithExpressionVisitor(LangRewritingContext context) {
        super(context);
    }

    @Override
    public Expression visit(SelectExpression selectExpression, ILangExpression arg) throws CompilationException {
        if (selectExpression.hasLetClauses()) {
            HashMap<Expression, Expression> varExprMap = new HashMap<Expression, Expression>();
            List<LetClause> withs = selectExpression.getLetList();
            Iterator<LetClause> with = withs.iterator();
            while (with.hasNext()) {
                LetClause letClause = with.next();
                Expression expr = letClause.getBindingExpr();
                Expression newBindingExpr = SqlppRewriteUtil.substituteExpression(expr, varExprMap, this.context);
                letClause.setBindingExpr(newBindingExpr);
                super.visit(newBindingExpr, arg);
                with.remove();
                Expression bindingExpr = letClause.getBindingExpr();
                varExprMap.put((Expression)letClause.getVarExpr(), bindingExpr);
            }
            SelectExpression newSelectExpression = (SelectExpression)SqlppRewriteUtil.substituteExpression((Expression)selectExpression, varExprMap, this.context);
            return super.visit(newSelectExpression, arg);
        }
        return super.visit(selectExpression, arg);
    }
}

