/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.SqlppSubstituteExpressionVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;

public class InlineColumnAliasVisitor
extends AbstractSqlppExpressionScopingVisitor {
    public InlineColumnAliasVisitor(LangRewritingContext context) {
        super(context);
    }

    @Override
    public Expression visit(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        Map<Expression, Expression> map = this.getMap(selectBlock.getSelectClause());
        if (selectBlock.hasFromClause()) {
            map.keySet().removeAll(SqlppVariableUtil.getBindingVariables(selectBlock.getFromClause()));
        }
        if (selectBlock.hasLetClauses()) {
            map.keySet().removeAll(SqlppVariableUtil.getBindingVariables(selectBlock.getLetList()));
        }
        SqlppSubstituteExpressionVisitor visitor = new SqlppSubstituteExpressionVisitor(this.context, map);
        SelectExpression selectExpression = (SelectExpression)arg;
        if (!selectExpression.getSelectSetOperation().hasRightInputs()) {
            if (selectExpression.hasOrderby()) {
                selectExpression.getOrderbyClause().accept((ILangVisitor)visitor, (Object)arg);
            }
            if (selectExpression.hasLimit()) {
                selectExpression.getLimitClause().accept((ILangVisitor)visitor, (Object)arg);
            }
        }
        return super.visit(selectBlock, arg);
    }

    private Map<Expression, Expression> getMap(SelectClause selectClause) throws CompilationException {
        if (selectClause.selectElement()) {
            return this.getMap(selectClause.getSelectElement());
        }
        if (selectClause.selectRegular()) {
            return this.getMap(selectClause.getSelectRegular());
        }
        return null;
    }

    private Map<Expression, Expression> getMap(SelectElement selectElement) {
        Expression expr = selectElement.getExpression();
        if (expr.getKind() == Expression.Kind.RECORD_CONSTRUCTOR_EXPRESSION) {
            return this.mapRecordConstructor((RecordConstructor)expr);
        }
        return Collections.emptyMap();
    }

    private Map<Expression, Expression> getMap(SelectRegular selectRegular) {
        return this.mapProjections(selectRegular.getProjections());
    }

    private Map<Expression, Expression> mapRecordConstructor(RecordConstructor rc) {
        HashMap<Expression, Expression> exprMap = new HashMap<Expression, Expression>();
        for (FieldBinding binding : rc.getFbList()) {
            LiteralExpr literalExpr;
            Expression leftExpr = binding.getLeftExpr();
            if (leftExpr.getKind() != Expression.Kind.LITERAL_EXPRESSION || (literalExpr = (LiteralExpr)leftExpr).getValue().getLiteralType() != Literal.Type.STRING) continue;
            String fieldName = SqlppVariableUtil.toInternalVariableName(literalExpr.getValue().getStringValue());
            exprMap.put((Expression)new VariableExpr(new VarIdentifier(fieldName)), binding.getRightExpr());
        }
        return exprMap;
    }

    private Map<Expression, Expression> mapProjections(List<Projection> projections) {
        HashMap<Expression, Expression> exprMap = new HashMap<Expression, Expression>();
        for (Projection projection : projections) {
            if (projection.star() || projection.varStar()) continue;
            exprMap.put((Expression)new VariableExpr(new VarIdentifier(SqlppVariableUtil.toInternalVariableName(projection.getName()))), projection.getExpression());
        }
        return exprMap;
    }
}

