/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.utils;

import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class LogicalOperatorDotVisitor
implements ILogicalOperatorVisitor<String, Void> {
    private final StringBuilder stringBuilder = new StringBuilder();

    public String toString() {
        return "";
    }

    private CharSequence str(Object o) {
        return String.valueOf(o);
    }

    @Override
    public String visitAggregateOperator(AggregateOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("aggregate ").append(this.str(op.getVariables())).append(" <- ");
        this.pprintExprList(op.getExpressions());
        return this.stringBuilder.toString();
    }

    @Override
    public String visitRunningAggregateOperator(RunningAggregateOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("running-aggregate ").append(this.str(op.getVariables())).append(" <- ");
        this.pprintExprList(op.getExpressions());
        return this.stringBuilder.toString();
    }

    @Override
    public String visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("empty-tuple-source");
        return this.stringBuilder.toString();
    }

    @Override
    public String visitGroupByOperator(GroupByOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("group by").append(op.isGroupAll() ? " (all)" : "").append(" (");
        this.pprintVeList(op.getGroupByList());
        this.stringBuilder.append(") decor (");
        this.pprintVeList(op.getDecorList());
        this.stringBuilder.append(")");
        return this.stringBuilder.toString();
    }

    @Override
    public String visitDistinctOperator(DistinctOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("distinct (");
        this.pprintExprList(op.getExpressions());
        this.stringBuilder.append(")");
        return this.stringBuilder.toString();
    }

    @Override
    public String visitInnerJoinOperator(InnerJoinOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("join (").append(((ILogicalExpression)op.getCondition().getValue()).toString()).append(")");
        return this.stringBuilder.toString();
    }

    @Override
    public String visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("left outer join (").append(((ILogicalExpression)op.getCondition().getValue()).toString()).append(")");
        return this.stringBuilder.toString();
    }

    @Override
    public String visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("nested tuple source");
        return this.stringBuilder.toString();
    }

    @Override
    public String visitOrderOperator(OrderOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("order ");
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> p : op.getOrderExpressions()) {
            if (op.getTopK() != -1) {
                this.stringBuilder.append("(topK: ").append(op.getTopK()).append(") ");
            }
            String fst = this.getOrderString((OrderOperator.IOrder)p.first);
            this.stringBuilder.append("(").append(fst).append(", ").append(((ILogicalExpression)((Mutable)p.second).getValue()).toString()).append(") ");
        }
        return this.stringBuilder.toString();
    }

    private String getOrderString(OrderOperator.IOrder first) {
        switch (first.getKind()) {
            case ASC: {
                return "ASC";
            }
            case DESC: {
                return "DESC";
            }
        }
        return first.getExpressionRef().toString();
    }

    @Override
    public String visitAssignOperator(AssignOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("assign ").append(this.str(op.getVariables())).append(" <- ");
        this.pprintExprList(op.getExpressions());
        return this.stringBuilder.toString();
    }

    @Override
    public String visitWriteOperator(WriteOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("write ");
        this.pprintExprList(op.getExpressions());
        return this.stringBuilder.toString();
    }

    @Override
    public String visitDistributeResultOperator(DistributeResultOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("distribute result ");
        this.pprintExprList(op.getExpressions());
        return this.stringBuilder.toString();
    }

    @Override
    public String visitWriteResultOperator(WriteResultOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("load ").append(this.str(op.getDataSource())).append(" from ").append(((ILogicalExpression)op.getPayloadExpression().getValue()).toString()).append(" partitioned by ");
        this.pprintExprList(op.getKeyExpressions());
        return this.stringBuilder.toString();
    }

    @Override
    public String visitSelectOperator(SelectOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("select (").append(((ILogicalExpression)op.getCondition().getValue()).toString()).append(")");
        return this.stringBuilder.toString();
    }

    @Override
    public String visitProjectOperator(ProjectOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("project ").append("(").append(op.getVariables()).append(")");
        return this.stringBuilder.toString();
    }

    @Override
    public String visitSubplanOperator(SubplanOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("subplan {}");
        return this.stringBuilder.toString();
    }

    @Override
    public String visitUnionOperator(UnionAllOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("union");
        for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> v : op.getVariableMappings()) {
            this.stringBuilder.append(" (").append(v.first).append(", ").append(v.second).append(", ").append(v.third).append(")");
        }
        return this.stringBuilder.toString();
    }

    @Override
    public String visitIntersectOperator(IntersectOperator op, Void noArgs) throws AlgebricksException {
        int i;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("intersect (");
        this.stringBuilder.append('[');
        for (i = 0; i < op.getOutputVars().size(); ++i) {
            if (i > 0) {
                this.stringBuilder.append(", ");
            }
            this.stringBuilder.append(this.str(op.getOutputVars().get(i)));
        }
        this.stringBuilder.append("] <- [");
        for (i = 0; i < op.getNumInput(); ++i) {
            if (i > 0) {
                this.stringBuilder.append(", ");
            }
            this.stringBuilder.append('[');
            for (int j = 0; j < op.getInputVariables(i).size(); ++j) {
                if (j > 0) {
                    this.stringBuilder.append(", ");
                }
                this.stringBuilder.append(this.str(op.getInputVariables(i).get(j)));
            }
            this.stringBuilder.append(']');
        }
        this.stringBuilder.append("])");
        return this.stringBuilder.toString();
    }

    @Override
    public String visitUnnestOperator(UnnestOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("unnest ").append(op.getVariable());
        if (op.getPositionalVariable() != null) {
            this.stringBuilder.append(" at ").append(op.getPositionalVariable());
        }
        this.stringBuilder.append(" <- ").append(((ILogicalExpression)op.getExpressionRef().getValue()).toString());
        return this.stringBuilder.toString();
    }

    @Override
    public String visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("outer-unnest ").append(op.getVariable());
        if (op.getPositionalVariable() != null) {
            this.stringBuilder.append(" at ").append(op.getPositionalVariable());
        }
        this.stringBuilder.append(" <- ").append(((ILogicalExpression)op.getExpressionRef().getValue()).toString());
        return this.stringBuilder.toString();
    }

    @Override
    public String visitUnnestMapOperator(UnnestMapOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        return this.printAbstractUnnestMapOperator(op, "unnest-map");
    }

    @Override
    public String visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        return this.printAbstractUnnestMapOperator(op, "left-outer-unnest-map");
    }

    private String printAbstractUnnestMapOperator(AbstractUnnestMapOperator op, String opSignature) {
        this.stringBuilder.append(opSignature).append(" ").append(op.getVariables()).append(" <- ").append(((ILogicalExpression)op.getExpressionRef().getValue()).toString());
        this.appendFilterInformation(this.stringBuilder, op.getMinFilterVars(), op.getMaxFilterVars());
        return this.stringBuilder.toString();
    }

    @Override
    public String visitDataScanOperator(DataSourceScanOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("data-scan ").append(op.getProjectVariables()).append("<-").append(op.getVariables()).append(" <- ").append(op.getDataSource());
        this.appendFilterInformation(this.stringBuilder, op.getMinFilterVars(), op.getMaxFilterVars());
        return this.stringBuilder.toString();
    }

    private String appendFilterInformation(StringBuilder plan, List<LogicalVariable> minFilterVars, List<LogicalVariable> maxFilterVars) {
        if (minFilterVars != null || maxFilterVars != null) {
            plan.append(" with filter on");
        }
        if (minFilterVars != null) {
            plan.append(" min:").append(minFilterVars);
        }
        if (maxFilterVars != null) {
            plan.append(" max:").append(maxFilterVars);
        }
        return this.stringBuilder.toString();
    }

    @Override
    public String visitLimitOperator(LimitOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("limit ").append(((ILogicalExpression)op.getMaxObjects().getValue()).toString());
        ILogicalExpression offset = (ILogicalExpression)op.getOffset().getValue();
        if (offset != null) {
            this.stringBuilder.append(", ").append(offset.toString());
        }
        return this.stringBuilder.toString();
    }

    @Override
    public String visitExchangeOperator(ExchangeOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("exchange");
        return this.stringBuilder.toString();
    }

    @Override
    public String visitScriptOperator(ScriptOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("script (in: ").append(op.getInputVariables()).append(") (out: ").append(op.getOutputVariables()).append(")");
        return this.stringBuilder.toString();
    }

    @Override
    public String visitReplicateOperator(ReplicateOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("replicate");
        return this.stringBuilder.toString();
    }

    @Override
    public String visitSplitOperator(SplitOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        Mutable<ILogicalExpression> branchingExpression = op.getBranchingExpression();
        this.stringBuilder.append("split ").append(((ILogicalExpression)branchingExpression.getValue()).toString());
        return this.stringBuilder.toString();
    }

    @Override
    public String visitMaterializeOperator(MaterializeOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("materialize");
        return this.stringBuilder.toString();
    }

    @Override
    public String visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        String header = this.getIndexOpString(op.getOperation());
        this.stringBuilder.append(header).append(this.str(op.getDataSource())).append(" from record: ").append(((ILogicalExpression)op.getPayloadExpression().getValue()).toString());
        if (op.getAdditionalNonFilteringExpressions() != null) {
            this.stringBuilder.append(", meta: ");
            this.pprintExprList(op.getAdditionalNonFilteringExpressions());
        }
        this.stringBuilder.append(" partitioned by ");
        this.pprintExprList(op.getPrimaryKeyExpressions());
        if (op.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
            this.stringBuilder.append(" out: ([record-before-upsert:").append(op.getBeforeOpRecordVar());
            if (op.getBeforeOpAdditionalNonFilteringVars() != null) {
                this.stringBuilder.append(", additional-before-upsert: ").append(op.getBeforeOpAdditionalNonFilteringVars());
            }
            this.stringBuilder.append("]) ");
        }
        if (op.isBulkload()) {
            this.stringBuilder.append(" [bulkload]");
        }
        return this.stringBuilder.toString();
    }

    @Override
    public String visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        String header = this.getIndexOpString(op.getOperation());
        this.stringBuilder.append(header).append(op.getIndexName()).append(" on ").append(this.str(op.getDataSourceIndex().getDataSource())).append(" from ");
        if (op.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
            this.stringBuilder.append(" replace:");
            this.pprintExprList(op.getPrevSecondaryKeyExprs());
            this.stringBuilder.append(" with:");
            this.pprintExprList(op.getSecondaryKeyExpressions());
        } else {
            this.pprintExprList(op.getSecondaryKeyExpressions());
        }
        if (op.isBulkload()) {
            this.stringBuilder.append(" [bulkload]");
        }
        return this.stringBuilder.toString();
    }

    private String getIndexOpString(InsertDeleteUpsertOperator.Kind opKind) {
        switch (opKind) {
            case DELETE: {
                return "delete from ";
            }
            case INSERT: {
                return "insert into ";
            }
            case UPSERT: {
                return "upsert into ";
            }
        }
        return null;
    }

    @Override
    public String visitTokenizeOperator(TokenizeOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("tokenize ").append(this.str(op.getTokenizeVars())).append(" <- ");
        this.pprintExprList(op.getSecondaryKeyExpressions());
        return this.stringBuilder.toString();
    }

    @Override
    public String visitSinkOperator(SinkOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("sink");
        return this.stringBuilder.toString();
    }

    @Override
    public String visitDelegateOperator(DelegateOperator op, Void noArgs) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(op.toString());
        return this.stringBuilder.toString();
    }

    private void pprintExprList(List<Mutable<ILogicalExpression>> expressions) {
        this.stringBuilder.append("[");
        boolean first = true;
        for (Mutable<ILogicalExpression> exprRef : expressions) {
            if (first) {
                first = false;
            } else {
                this.stringBuilder.append(", ");
            }
            this.stringBuilder.append(((ILogicalExpression)exprRef.getValue()).toString());
        }
        this.stringBuilder.append("]");
    }

    private void pprintVeList(List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> vePairList) {
        this.stringBuilder.append("[");
        boolean fst = true;
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> ve : vePairList) {
            if (fst) {
                fst = false;
            } else {
                this.stringBuilder.append("; ");
            }
            if (ve.first != null) {
                this.stringBuilder.append(ve.first).append(" := ").append(ve.second);
                continue;
            }
            this.stringBuilder.append(((ILogicalExpression)((Mutable)ve.second).getValue()).toString());
        }
        this.stringBuilder.append("]");
    }
}

