/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPropagatePropertiesForUsedVariablesPOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.scripting.IScriptDescription;
import org.apache.hyracks.algebricks.core.algebra.scripting.StringStreamingScriptDescription;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.std.StringStreamingRuntimeFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;

public class StringStreamingScriptPOperator
extends AbstractPropagatePropertiesForUsedVariablesPOperator {
    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.STRING_STREAM_SCRIPT;
    }

    @Override
    public boolean isMicroOperator() {
        return true;
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        return this.emptyUnaryRequirements();
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        ScriptOperator scriptOp = (ScriptOperator)op;
        IScriptDescription scriptDesc = scriptOp.getScriptDescription();
        if (scriptDesc.getKind() != IScriptDescription.ScriptKind.STRING_STREAMING) {
            throw new IllegalStateException();
        }
        StringStreamingScriptDescription sssd = (StringStreamingScriptDescription)scriptDesc;
        StringStreamingRuntimeFactory runtime = new StringStreamingRuntimeFactory(sssd.getCommand(), sssd.getPrinterFactories(), sssd.getFieldDelimiter(), sssd.getParserFactory());
        RecordDescriptor recDesc = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment(op), propagatedSchema, context);
        builder.contributeMicroOperator(scriptOp, (IPushRuntimeFactory)runtime, recDesc);
        ILogicalOperator src = (ILogicalOperator)scriptOp.getInputs().get(0).getValue();
        builder.contributeGraphEdge(src, 0, scriptOp, 0);
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        ScriptOperator s = (ScriptOperator)op;
        this.computeDeliveredPropertiesForUsedVariables(s, s.getInputVariables());
    }

    @Override
    public boolean expensiveThanMaterialization() {
        return false;
    }
}

