/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.ITuplePairComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;

class JoinMultiComparator
implements ITuplePairComparator {
    private final IBinaryComparator[] binaryComparators;
    private final int[] keysLeft;
    private final int[] keysRight;

    public JoinMultiComparator(IBinaryComparator[] bComparator, int[] keysLeft, int[] keysRight) {
        this.binaryComparators = bComparator;
        this.keysLeft = keysLeft;
        this.keysRight = keysRight;
    }

    public int compare(IFrameTupleAccessor accessor0, int tIndex0, IFrameTupleAccessor accessor1, int tIndex1) throws HyracksDataException {
        int tStart0 = accessor0.getTupleStartOffset(tIndex0);
        int fStartOffset0 = accessor0.getFieldSlotsLength() + tStart0;
        int tStart1 = accessor1.getTupleStartOffset(tIndex1);
        int fStartOffset1 = accessor1.getFieldSlotsLength() + tStart1;
        for (int i = 0; i < this.binaryComparators.length; ++i) {
            int fStart0 = accessor0.getFieldStartOffset(tIndex0, this.keysLeft[i]);
            int fEnd0 = accessor0.getFieldEndOffset(tIndex0, this.keysLeft[i]);
            int fLen0 = fEnd0 - fStart0;
            int fStart1 = accessor1.getFieldStartOffset(tIndex1, this.keysRight[i]);
            int fEnd1 = accessor1.getFieldEndOffset(tIndex1, this.keysRight[i]);
            int fLen1 = fEnd1 - fStart1;
            int c = this.binaryComparators[i].compare(accessor0.getBuffer().array(), fStart0 + fStartOffset0, fLen0, accessor1.getBuffer().array(), fStart1 + fStartOffset1, fLen1);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }
}

