/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.UnorderedPartitionedProperty;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;

public abstract class AbstractPreSortedDistinctByPOperator
extends AbstractPhysicalOperator {
    protected List<LogicalVariable> columnList;

    public AbstractPreSortedDistinctByPOperator(List<LogicalVariable> columnList) {
        this.columnList = columnList;
    }

    public void setDistinctByColumns(List<LogicalVariable> distinctByColumns) {
        this.columnList = distinctByColumns;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)op.getInputs().get(0).getValue();
        IPartitioningProperty pp = op2.getDeliveredPhysicalProperties().getPartitioningProperty();
        List<ILocalStructuralProperty> propsLocal = op2.getDeliveredPhysicalProperties().getLocalProperties();
        this.deliveredProperties = new StructuralPropertiesVector(pp, propsLocal);
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        IPhysicalPropertiesVector[] pv = new StructuralPropertiesVector[1];
        ArrayList<ILocalStructuralProperty> localProps = new ArrayList<ILocalStructuralProperty>();
        ArrayList<OrderColumn> orderColumns = new ArrayList<OrderColumn>();
        for (LogicalVariable column : this.columnList) {
            orderColumns.add(new OrderColumn(column, OrderOperator.IOrder.OrderKind.ASC));
        }
        localProps.add(new LocalOrderProperty(orderColumns));
        UnorderedPartitionedProperty pp = null;
        AbstractLogicalOperator aop = (AbstractLogicalOperator)op;
        if (aop.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.PARTITIONED) {
            pp = new UnorderedPartitionedProperty((Set<LogicalVariable>)new ListSet(this.columnList), context.getComputationNodeDomain());
        }
        pv[0] = new StructuralPropertiesVector(pp, localProps);
        return new PhysicalRequirements(pv, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    @Override
    public boolean expensiveThanMaterialization() {
        return true;
    }

    protected int[] getKeysAndDecs(IOperatorSchema inputSchema) {
        int i;
        int[] keys = JobGenHelper.variablesToFieldIndexes(this.columnList, inputSchema);
        int sz = inputSchema.getSize();
        int fdSz = sz - this.columnList.size();
        int[] fdColumns = new int[fdSz];
        int j = 0;
        for (LogicalVariable v : inputSchema) {
            if (this.columnList.contains(v)) continue;
            fdColumns[j++] = inputSchema.findVariable(v);
        }
        int[] keysAndDecs = new int[keys.length + fdColumns.length];
        for (i = 0; i < keys.length; ++i) {
            keysAndDecs[i] = keys[i];
        }
        for (i = 0; i < fdColumns.length; ++i) {
            keysAndDecs[i + keys.length] = fdColumns[i];
        }
        return keysAndDecs;
    }
}

