/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.IsomorphismOperatorVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.IsomorphismVariableMappingVisitor;

public class IsomorphismUtilities {
    public static void mapVariablesTopDown(ILogicalOperator op, ILogicalOperator arg, Map<LogicalVariable, LogicalVariable> variableMapping) throws AlgebricksException {
        IsomorphismVariableMappingVisitor visitor = new IsomorphismVariableMappingVisitor(variableMapping);
        op.accept(visitor, arg);
    }

    public static boolean isOperatorIsomorphic(ILogicalOperator op, ILogicalOperator arg) throws AlgebricksException {
        IsomorphismOperatorVisitor visitor = new IsomorphismOperatorVisitor();
        return op.accept(visitor, arg);
    }

    public static boolean isOperatorIsomorphicPlanSegment(ILogicalOperator op, ILogicalOperator arg) throws AlgebricksException {
        List<Mutable<ILogicalOperator>> inputs1 = op.getInputs();
        List<Mutable<ILogicalOperator>> inputs2 = arg.getInputs();
        if (inputs1.size() != inputs2.size()) {
            return false;
        }
        for (int i = 0; i < inputs1.size(); ++i) {
            ILogicalOperator input2;
            ILogicalOperator input1 = (ILogicalOperator)inputs1.get(i).getValue();
            boolean isomorphic = IsomorphismUtilities.isOperatorIsomorphicPlanSegment(input1, input2 = (ILogicalOperator)inputs2.get(i).getValue());
            if (isomorphic) continue;
            return false;
        }
        return IsomorphismUtilities.isOperatorIsomorphic(op, arg);
    }

    public static boolean isOperatorIsomorphicPlan(ILogicalPlan plan, ILogicalPlan arg) throws AlgebricksException {
        if (plan.getRoots().size() != arg.getRoots().size()) {
            return false;
        }
        for (int i = 0; i < plan.getRoots().size(); ++i) {
            ILogicalOperator topOp2;
            ILogicalOperator topOp1 = (ILogicalOperator)plan.getRoots().get(i).getValue();
            if (IsomorphismUtilities.isOperatorIsomorphicPlanSegment(topOp1, topOp2 = (ILogicalOperator)arg.getRoots().get(i).getValue())) continue;
            return false;
        }
        return true;
    }
}

