/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.FilteredVariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.typing.NonPropagatingTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.core.config.AlgebricksConfig;

public class IntersectOperator
extends AbstractLogicalOperator {
    private final List<List<LogicalVariable>> inputVars;
    private final List<List<LogicalVariable>> compareVars;
    private final List<LogicalVariable> outputVars;
    private List<List<LogicalVariable>> extraVars;

    public IntersectOperator(List<LogicalVariable> outputVars, List<List<LogicalVariable>> compareVars) throws AlgebricksException {
        this(outputVars, compareVars, compareVars.stream().map(vars -> new ArrayList()).collect(Collectors.toList()));
    }

    public IntersectOperator(List<LogicalVariable> outputVars, List<List<LogicalVariable>> compareVars, List<List<LogicalVariable>> extraVars) throws AlgebricksException {
        int numCompareFields = compareVars.get(0).size();
        if (compareVars.stream().anyMatch(vlist -> vlist.size() != numCompareFields)) {
            throw AlgebricksException.create((int)8, (Serializable[])new Serializable[0]);
        }
        int numExtraFields = extraVars.get(0).size();
        if (extraVars.stream().anyMatch(vlist -> vlist.size() != numExtraFields)) {
            throw AlgebricksException.create((int)8, (Serializable[])new Serializable[0]);
        }
        if (outputVars.size() != numCompareFields + numExtraFields) {
            throw AlgebricksException.create((int)8, (Serializable[])new Serializable[0]);
        }
        this.outputVars = new ArrayList<LogicalVariable>(outputVars);
        this.compareVars = new ArrayList<List<LogicalVariable>>(compareVars);
        this.inputVars = new ArrayList<List<LogicalVariable>>(compareVars.size());
        for (List<LogicalVariable> vars : compareVars) {
            this.inputVars.add(new ArrayList<LogicalVariable>(vars));
        }
        for (int i = 0; i < extraVars.size(); ++i) {
            this.inputVars.get(i).addAll((Collection<LogicalVariable>)extraVars.get(i));
        }
        this.extraVars = extraVars;
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.INTERSECT;
    }

    @Override
    public void recomputeSchema() throws AlgebricksException {
        this.schema = this.outputVars;
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform transform) throws AlgebricksException {
        return false;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitIntersectOperator(this, arg);
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return new FilteredVariablePropagationPolicy(this.outputVars);
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        int i;
        IVariableTypeEnvironment typeEnv = ctx.getOutputTypeEnvironment((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue());
        for (int i2 = 1; i2 < this.inputs.size(); ++i2) {
            this.checkTypeConsistency(typeEnv, this.compareVars.get(0), ctx.getOutputTypeEnvironment((ILogicalOperator)((Mutable)this.inputs.get(i2)).getValue()), this.compareVars.get(i2));
        }
        NonPropagatingTypeEnvironment env = new NonPropagatingTypeEnvironment(ctx.getExpressionTypeComputer(), ctx.getMetadataProvider());
        for (i = 0; i < this.compareVars.get(0).size(); ++i) {
            env.setVarType(this.outputVars.get(i), typeEnv.getVarType(this.compareVars.get(0).get(i)));
        }
        if (this.extraVars != null) {
            for (int k = 0; k < this.extraVars.get(0).size(); ++k) {
                env.setVarType(this.outputVars.get(i + k), typeEnv.getVarType(this.extraVars.get(0).get(k)));
            }
        }
        return typeEnv;
    }

    public List<LogicalVariable> getOutputVars() {
        return this.outputVars;
    }

    public int getNumInput() {
        return this.compareVars.size();
    }

    public List<LogicalVariable> getCompareVariables(int inputIndex) {
        return this.compareVars.get(inputIndex);
    }

    public List<List<LogicalVariable>> getExtraVariables() {
        return this.extraVars;
    }

    public List<LogicalVariable> getInputVariables(int inputIndex) {
        return this.inputVars.get(inputIndex);
    }

    private void checkTypeConsistency(IVariableTypeEnvironment expected, List<LogicalVariable> expectedVariables, IVariableTypeEnvironment actual, List<LogicalVariable> actualVariables) throws AlgebricksException {
        for (int i = 0; i < expectedVariables.size(); ++i) {
            Object actualType;
            Object expectedType = expected.getVarType(expectedVariables.get(i));
            if (expectedType.equals(actualType = actual.getVarType(actualVariables.get(i))) || !AlgebricksConfig.ALGEBRICKS_LOGGER.isWarnEnabled()) continue;
            AlgebricksConfig.ALGEBRICKS_LOGGER.warn("Type of two variables are not equal." + expectedVariables.get(i) + " is of type: " + expectedType + actualVariables.get(i) + " is of type: " + actualType);
        }
    }
}

