/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.expressions;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;

public class VariableReferenceExpression
extends AbstractLogicalExpression {
    private int tupleRef;
    private LogicalVariable variable;

    public VariableReferenceExpression(int tupleRef, LogicalVariable variable) {
        if (variable == null) {
            throw new NullPointerException();
        }
        this.tupleRef = tupleRef;
        this.variable = variable;
    }

    public VariableReferenceExpression(LogicalVariable variable) {
        this(0, variable);
    }

    public LogicalVariable getVariableReference() {
        return this.variable;
    }

    public void setVariable(LogicalVariable variable) {
        this.variable = variable;
    }

    @Override
    public LogicalExpressionTag getExpressionTag() {
        return LogicalExpressionTag.VARIABLE;
    }

    public String toString() {
        return this.variable.toString();
    }

    @Override
    public void getUsedVariables(Collection<LogicalVariable> vars) {
        vars.add(this.variable);
    }

    @Override
    public void substituteVar(LogicalVariable v1, LogicalVariable v2) {
        if (this.variable.equals(v1)) {
            this.variable = v2;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof VariableReferenceExpression) {
            VariableReferenceExpression varRefExpr = (VariableReferenceExpression)obj;
            return this.tupleRef == varRefExpr.tupleRef && this.variable.equals(varRefExpr.getVariableReference());
        }
        return false;
    }

    public int hashCode() {
        return this.tupleRef + this.variable.hashCode();
    }

    @Override
    public <R, T> R accept(ILogicalExpressionVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitVariableReferenceExpression(this, arg);
    }

    @Override
    public AbstractLogicalExpression cloneExpression() {
        return new VariableReferenceExpression(this.variable);
    }

    @Override
    public boolean splitIntoConjuncts(List<Mutable<ILogicalExpression>> conjs) {
        return false;
    }
}

