/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.job.profiling;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.api.job.profiling.counters.ICounter;
import org.apache.hyracks.control.common.job.profiling.counters.Counter;

public class OperatorStats
implements IOperatorStats {
    public final String operatorName;
    public final ICounter tupleCounter;
    public final ICounter timeCounter;

    public OperatorStats(String operatorName) {
        if (operatorName == null || operatorName.isEmpty()) {
            throw new IllegalArgumentException("operatorName must not be null or empty");
        }
        this.operatorName = operatorName;
        this.tupleCounter = new Counter("tupleCounter");
        this.timeCounter = new Counter("timeCounter");
    }

    public static IOperatorStats create(DataInput input) throws IOException {
        String name = input.readUTF();
        OperatorStats operatorStats = new OperatorStats(name);
        operatorStats.readFields(input);
        return operatorStats;
    }

    public String getName() {
        return this.operatorName;
    }

    public ICounter getTupleCounter() {
        return this.tupleCounter;
    }

    public ICounter getTimeCounter() {
        return this.timeCounter;
    }

    public void writeFields(DataOutput output) throws IOException {
        output.writeUTF(this.operatorName);
        output.writeLong(this.tupleCounter.get());
        output.writeLong(this.timeCounter.get());
    }

    public void readFields(DataInput input) throws IOException {
        this.tupleCounter.set(input.readLong());
        this.timeCounter.set(input.readLong());
    }
}

