/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.heartbeat;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.util.MXHelper;

public class HeartbeatData {
    public long heapInitSize;
    public long heapUsedSize;
    public long heapCommittedSize;
    public long heapMaxSize;
    public long nonheapInitSize;
    public long nonheapUsedSize;
    public long nonheapCommittedSize;
    public long nonheapMaxSize;
    public int threadCount;
    public int peakThreadCount;
    public long totalStartedThreadCount;
    public double systemLoadAverage;
    public long[] gcCollectionCounts = new long[MXHelper.gcMXBeans.size()];
    public long[] gcCollectionTimes = new long[MXHelper.gcMXBeans.size()];
    public long netPayloadBytesRead;
    public long netPayloadBytesWritten;
    public long netSignalingBytesRead;
    public long netSignalingBytesWritten;
    public long datasetNetPayloadBytesRead;
    public long datasetNetPayloadBytesWritten;
    public long datasetNetSignalingBytesRead;
    public long datasetNetSignalingBytesWritten;
    public long ipcMessagesSent;
    public long ipcMessageBytesSent;
    public long ipcMessagesReceived;
    public long ipcMessageBytesReceived;
    public long diskReads;
    public long diskWrites;
    public int numCores;

    public void readFields(DataInput dis) throws IOException {
        this.heapInitSize = dis.readLong();
        this.heapUsedSize = dis.readLong();
        this.heapCommittedSize = dis.readLong();
        this.heapMaxSize = dis.readLong();
        this.nonheapInitSize = dis.readLong();
        this.nonheapUsedSize = dis.readLong();
        this.nonheapCommittedSize = dis.readLong();
        this.nonheapMaxSize = dis.readLong();
        this.threadCount = dis.readInt();
        this.peakThreadCount = dis.readInt();
        this.totalStartedThreadCount = dis.readLong();
        this.systemLoadAverage = dis.readDouble();
        this.netPayloadBytesRead = dis.readLong();
        this.netPayloadBytesWritten = dis.readLong();
        this.netSignalingBytesRead = dis.readLong();
        this.netSignalingBytesWritten = dis.readLong();
        this.netSignalingBytesWritten = dis.readLong();
        this.datasetNetPayloadBytesWritten = dis.readLong();
        this.datasetNetSignalingBytesRead = dis.readLong();
        this.datasetNetSignalingBytesWritten = dis.readLong();
        this.ipcMessagesSent = dis.readLong();
        this.ipcMessageBytesSent = dis.readLong();
        this.ipcMessagesReceived = dis.readLong();
        this.ipcMessageBytesReceived = dis.readLong();
        this.diskReads = dis.readLong();
        this.diskWrites = dis.readLong();
        this.numCores = dis.readInt();
        int gcCounts = dis.readInt();
        this.gcCollectionCounts = new long[gcCounts];
        for (int i = 0; i < this.gcCollectionCounts.length; ++i) {
            this.gcCollectionCounts[i] = dis.readLong();
        }
        int gcTimeCounts = dis.readInt();
        this.gcCollectionTimes = new long[gcTimeCounts];
        for (int i = 0; i < this.gcCollectionTimes.length; ++i) {
            this.gcCollectionTimes[i] = dis.readLong();
        }
    }

    public void write(DataOutput dos) throws IOException {
        int i;
        dos.writeLong(this.heapInitSize);
        dos.writeLong(this.heapUsedSize);
        dos.writeLong(this.heapCommittedSize);
        dos.writeLong(this.heapMaxSize);
        dos.writeLong(this.nonheapInitSize);
        dos.writeLong(this.nonheapUsedSize);
        dos.writeLong(this.nonheapCommittedSize);
        dos.writeLong(this.nonheapMaxSize);
        dos.writeInt(this.threadCount);
        dos.writeInt(this.peakThreadCount);
        dos.writeLong(this.totalStartedThreadCount);
        dos.writeDouble(this.systemLoadAverage);
        dos.writeLong(this.netPayloadBytesRead);
        dos.writeLong(this.netPayloadBytesWritten);
        dos.writeLong(this.netSignalingBytesRead);
        dos.writeLong(this.netSignalingBytesWritten);
        dos.writeLong(this.datasetNetPayloadBytesRead);
        dos.writeLong(this.datasetNetPayloadBytesWritten);
        dos.writeLong(this.datasetNetSignalingBytesRead);
        dos.writeLong(this.datasetNetSignalingBytesWritten);
        dos.writeLong(this.ipcMessagesSent);
        dos.writeLong(this.ipcMessageBytesSent);
        dos.writeLong(this.ipcMessagesReceived);
        dos.writeLong(this.ipcMessageBytesReceived);
        dos.writeLong(this.diskReads);
        dos.writeLong(this.diskWrites);
        dos.writeInt(this.numCores);
        dos.writeInt(this.gcCollectionCounts.length);
        for (i = 0; i < this.gcCollectionCounts.length; ++i) {
            dos.writeLong(this.gcCollectionCounts[i]);
        }
        dos.writeInt(this.gcCollectionTimes.length);
        for (i = 0; i < this.gcCollectionTimes.length; ++i) {
            dos.writeLong(this.gcCollectionTimes[i]);
        }
    }
}

