/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.dataset;

import org.apache.hyracks.api.dataset.IDatasetManager;
import org.apache.logging.log4j.Logger;

public class ResultStateSweeper
implements Runnable {
    private final IDatasetManager datasetManager;
    private final long resultSweepThreshold;
    private final Logger logger;

    public ResultStateSweeper(IDatasetManager datasetManager, long resultSweepThreshold, Logger logger) {
        this.datasetManager = datasetManager;
        this.resultSweepThreshold = resultSweepThreshold;
        this.logger = logger;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(this.resultSweepThreshold);
                this.datasetManager.sweepExpiredDatasets();
                this.logger.trace("Result state cleanup instance successfully completed.");
            }
            catch (InterruptedException e) {
                this.logger.warn("Result cleaner thread interrupted, shutting down.");
                Thread.currentThread().interrupt();
            }
        }
    }
}

