/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.dataset;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.api.dataset.IDatasetManager;
import org.apache.hyracks.api.dataset.IDatasetStateRecord;
import org.apache.hyracks.api.job.JobId;

public abstract class AbstractDatasetManager
implements IDatasetManager {
    private final long nanoResultTTL;

    protected AbstractDatasetManager(long resultTTL) {
        this.nanoResultTTL = TimeUnit.MILLISECONDS.toNanos(resultTTL);
    }

    public synchronized void sweepExpiredDatasets() {
        ArrayList<JobId> expiredDatasets = new ArrayList<JobId>();
        long sweepTime = System.nanoTime();
        for (JobId jobId : this.getJobIds()) {
            IDatasetStateRecord state = this.getState(jobId);
            if (state == null || !AbstractDatasetManager.hasExpired(state, sweepTime, this.nanoResultTTL)) continue;
            expiredDatasets.add(jobId);
        }
        for (JobId jobId : expiredDatasets) {
            this.sweep(jobId);
        }
    }

    private static boolean hasExpired(IDatasetStateRecord dataset, long currentTime, long ttl) {
        return currentTime - dataset.getTimestamp() - ttl > 0L;
    }
}

