/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.config;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.controllers.ControllerConfig;
import org.ini4j.Ini;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionHandlerFilter;

public class ConfigUtils {
    private static final int USAGE_WIDTH = 120;

    private ConfigUtils() {
    }

    private static <T> T getIniValue(Ini ini, String section, String key, T defaultValue, Class<T> clazz) {
        int idx;
        Object value;
        while ((value = ini.get((Object)section, (Object)key, clazz)) == null && (idx = section.lastIndexOf(47)) > -1) {
            section = section.substring(0, idx);
        }
        return (T)(value != null ? value : defaultValue);
    }

    public static String getString(Ini ini, String section, String key, String defaultValue) {
        return ConfigUtils.getIniValue(ini, section, key, defaultValue, String.class);
    }

    public static int getInt(Ini ini, String section, String key, int defaultValue) {
        return ConfigUtils.getIniValue(ini, section, key, defaultValue, Integer.class);
    }

    public static long getLong(Ini ini, String section, String key, long defaultValue) {
        return ConfigUtils.getIniValue(ini, section, key, defaultValue, Long.class);
    }

    public static Ini loadINIFile(String configFile) throws IOException {
        Ini ini = new Ini();
        File conffile = new File(configFile);
        if (!conffile.exists()) {
            throw new FileNotFoundException(configFile);
        }
        ini.load(conffile);
        return ini;
    }

    public static Ini loadINIFile(URL configURL) throws IOException {
        Ini ini = new Ini();
        ini.load(configURL);
        return ini;
    }

    public static Field[] getFields(Class beanClass, Predicate<Field> predicate) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class clazz = beanClass; clazz != null && clazz.getClassLoader() != null && clazz.getClassLoader().getParent() != null; clazz = clazz.getSuperclass()) {
            for (Field f : clazz.getDeclaredFields()) {
                if (!predicate.test(f)) continue;
                fields.add(f);
            }
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static void printUsage(CmdLineParser parser, OptionHandlerFilter filter, PrintStream out) {
        parser.getProperties().withUsageWidth(120);
        parser.printUsage((Writer)new OutputStreamWriter(out), null, filter);
    }

    public static void printUsage(CmdLineException e, OptionHandlerFilter filter, PrintStream out) {
        out.println("ERROR: " + e.getMessage());
        ConfigUtils.printUsage(e.getParser(), filter, out);
    }

    private static String getOptionValue(String[] args, String optionName) {
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].equals(optionName)) continue;
            return args[i + 1];
        }
        return null;
    }

    public static String getOptionValue(String[] args, IOption option) throws IOException {
        String value = ConfigUtils.getOptionValue(args, option.cmdline());
        if (value == null) {
            Ini iniFile = null;
            String configFile = ConfigUtils.getOptionValue(args, ControllerConfig.Option.CONFIG_FILE.cmdline());
            String configFileUrl = ConfigUtils.getOptionValue(args, ControllerConfig.Option.CONFIG_FILE_URL.cmdline());
            if (configFile != null) {
                iniFile = ConfigUtils.loadINIFile(configFile);
            } else if (configFileUrl != null) {
                iniFile = ConfigUtils.loadINIFile(new URL(configFileUrl));
            }
            if (iniFile != null) {
                value = iniFile.get((Object)option.section().sectionName(), (Object)option.ini());
            }
        }
        return value;
    }

    public static String getString(Ini ini, Section section, IOption option, String defaultValue) {
        return ConfigUtils.getString(ini, section.sectionName(), option.ini(), defaultValue);
    }

    public static void addConfigToJSON(ObjectNode o, IApplicationConfig cfg, Section ... sections) {
        ArrayNode configArray = o.putArray("config");
        for (Section section : cfg.getSections(Arrays.asList(sections)::contains)) {
            ObjectNode sectionNode = configArray.addObject();
            Map<String, Object> sectionConfig = ConfigUtils.getSectionOptionsForJSON(cfg, section, option -> true);
            sectionNode.put("section", section.sectionName()).putPOJO("properties", sectionConfig);
        }
    }

    public static Map<String, Object> getSectionOptionsForJSON(IApplicationConfig cfg, Section section, Predicate<IOption> selector) {
        TreeMap<String, Object> sectionConfig = new TreeMap<String, Object>();
        for (IOption option : cfg.getOptions(section)) {
            if (!selector.test(option)) continue;
            sectionConfig.put(option.ini(), option.type().serializeToJSON(cfg.get(option)));
        }
        return sectionConfig;
    }
}

