/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.resource.NodeCapacity;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.common.controllers.NodeRegistration;
import org.apache.hyracks.control.common.heartbeat.HeartbeatData;
import org.apache.hyracks.control.common.heartbeat.HeartbeatSchema;
import org.apache.hyracks.control.common.utils.ConfigurationUtil;
import org.apache.hyracks.util.JSONUtil;

public class NodeControllerData {
    private static final int RRD_SIZE = 720;
    private final NCConfig ncConfig;
    private final NetworkAddress dataPort;
    private final NetworkAddress datasetPort;
    private final NetworkAddress messagingPort;
    private final Set<JobId> activeJobIds;
    private final String osName;
    private final String arch;
    private final String osVersion;
    private final int nProcessors;
    private final String vmName;
    private final String vmVersion;
    private final String vmVendor;
    private final String classpath;
    private final String libraryPath;
    private final String bootClasspath;
    private final List<String> inputArguments;
    private final Map<String, String> systemProperties;
    private final int pid;
    private final HeartbeatSchema hbSchema;
    private final long[] hbTime;
    private final long[] heapInitSize;
    private final long[] heapUsedSize;
    private final long[] heapCommittedSize;
    private final long[] heapMaxSize;
    private final long[] nonheapInitSize;
    private final long[] nonheapUsedSize;
    private final long[] nonheapCommittedSize;
    private final long[] nonheapMaxSize;
    private final int[] threadCount;
    private final int[] peakThreadCount;
    private final double[] systemLoadAverage;
    private final String[] gcNames;
    private final long[][] gcCollectionCounts;
    private final long[][] gcCollectionTimes;
    private final long[] netPayloadBytesRead;
    private final long[] netPayloadBytesWritten;
    private final long[] netSignalingBytesRead;
    private final long[] netSignalingBytesWritten;
    private final long[] datasetNetPayloadBytesRead;
    private final long[] datasetNetPayloadBytesWritten;
    private final long[] datasetNetSignalingBytesRead;
    private final long[] datasetNetSignalingBytesWritten;
    private final long[] ipcMessagesSent;
    private final long[] ipcMessageBytesSent;
    private final long[] ipcMessagesReceived;
    private final long[] ipcMessageBytesReceived;
    private final long[] diskReads;
    private final long[] diskWrites;
    private int rrdPtr;
    private volatile long lastHeartbeatNanoTime;
    private NodeCapacity capacity;

    public NodeControllerData(NodeRegistration reg) {
        this.ncConfig = reg.getNCConfig();
        this.dataPort = reg.getDataPort();
        this.datasetPort = reg.getDatasetPort();
        this.messagingPort = reg.getMessagingPort();
        this.activeJobIds = new HashSet<JobId>();
        this.osName = reg.getOSName();
        this.arch = reg.getArch();
        this.osVersion = reg.getOSVersion();
        this.nProcessors = reg.getNProcessors();
        this.vmName = reg.getVmName();
        this.vmVersion = reg.getVmVersion();
        this.vmVendor = reg.getVmVendor();
        this.classpath = reg.getClasspath();
        this.libraryPath = reg.getLibraryPath();
        this.bootClasspath = reg.getBootClasspath();
        this.inputArguments = reg.getInputArguments();
        this.systemProperties = reg.getSystemProperties();
        this.pid = reg.getPid();
        this.hbSchema = reg.getHeartbeatSchema();
        this.hbTime = new long[720];
        this.heapInitSize = new long[720];
        this.heapUsedSize = new long[720];
        this.heapCommittedSize = new long[720];
        this.heapMaxSize = new long[720];
        this.nonheapInitSize = new long[720];
        this.nonheapUsedSize = new long[720];
        this.nonheapCommittedSize = new long[720];
        this.nonheapMaxSize = new long[720];
        this.threadCount = new int[720];
        this.peakThreadCount = new int[720];
        this.systemLoadAverage = new double[720];
        HeartbeatSchema.GarbageCollectorInfo[] gcInfos = this.hbSchema.getGarbageCollectorInfos();
        int gcN = gcInfos.length;
        this.gcNames = new String[gcN];
        for (int i = 0; i < gcN; ++i) {
            this.gcNames[i] = gcInfos[i].getName();
        }
        this.gcCollectionCounts = new long[gcN][720];
        this.gcCollectionTimes = new long[gcN][720];
        this.netPayloadBytesRead = new long[720];
        this.netPayloadBytesWritten = new long[720];
        this.netSignalingBytesRead = new long[720];
        this.netSignalingBytesWritten = new long[720];
        this.datasetNetPayloadBytesRead = new long[720];
        this.datasetNetPayloadBytesWritten = new long[720];
        this.datasetNetSignalingBytesRead = new long[720];
        this.datasetNetSignalingBytesWritten = new long[720];
        this.ipcMessagesSent = new long[720];
        this.ipcMessageBytesSent = new long[720];
        this.ipcMessagesReceived = new long[720];
        this.ipcMessageBytesReceived = new long[720];
        this.diskReads = new long[720];
        this.diskWrites = new long[720];
        this.rrdPtr = 0;
        this.capacity = reg.getCapacity();
        this.touchHeartbeat();
    }

    public synchronized void notifyHeartbeat(HeartbeatData hbData) {
        this.touchHeartbeat();
        this.hbTime[this.rrdPtr] = System.currentTimeMillis();
        this.heapInitSize[this.rrdPtr] = hbData.heapInitSize;
        this.heapUsedSize[this.rrdPtr] = hbData.heapUsedSize;
        this.heapCommittedSize[this.rrdPtr] = hbData.heapCommittedSize;
        this.heapMaxSize[this.rrdPtr] = hbData.heapMaxSize;
        this.nonheapInitSize[this.rrdPtr] = hbData.nonheapInitSize;
        this.nonheapUsedSize[this.rrdPtr] = hbData.nonheapUsedSize;
        this.nonheapCommittedSize[this.rrdPtr] = hbData.nonheapCommittedSize;
        this.nonheapMaxSize[this.rrdPtr] = hbData.nonheapMaxSize;
        this.threadCount[this.rrdPtr] = hbData.threadCount;
        this.peakThreadCount[this.rrdPtr] = hbData.peakThreadCount;
        this.systemLoadAverage[this.rrdPtr] = hbData.systemLoadAverage;
        int gcN = this.hbSchema.getGarbageCollectorInfos().length;
        for (int i = 0; i < gcN; ++i) {
            this.gcCollectionCounts[i][this.rrdPtr] = hbData.gcCollectionCounts[i];
            this.gcCollectionTimes[i][this.rrdPtr] = hbData.gcCollectionTimes[i];
        }
        this.netPayloadBytesRead[this.rrdPtr] = hbData.netPayloadBytesRead;
        this.netPayloadBytesWritten[this.rrdPtr] = hbData.netPayloadBytesWritten;
        this.netSignalingBytesRead[this.rrdPtr] = hbData.netSignalingBytesRead;
        this.netSignalingBytesWritten[this.rrdPtr] = hbData.netSignalingBytesWritten;
        this.datasetNetPayloadBytesRead[this.rrdPtr] = hbData.datasetNetPayloadBytesRead;
        this.datasetNetPayloadBytesWritten[this.rrdPtr] = hbData.datasetNetPayloadBytesWritten;
        this.datasetNetSignalingBytesRead[this.rrdPtr] = hbData.datasetNetSignalingBytesRead;
        this.datasetNetSignalingBytesWritten[this.rrdPtr] = hbData.datasetNetSignalingBytesWritten;
        this.ipcMessagesSent[this.rrdPtr] = hbData.ipcMessagesSent;
        this.ipcMessageBytesSent[this.rrdPtr] = hbData.ipcMessageBytesSent;
        this.ipcMessagesReceived[this.rrdPtr] = hbData.ipcMessagesReceived;
        this.ipcMessageBytesReceived[this.rrdPtr] = hbData.ipcMessageBytesReceived;
        this.diskReads[this.rrdPtr] = hbData.diskReads;
        this.diskWrites[this.rrdPtr] = hbData.diskWrites;
        this.rrdPtr = (this.rrdPtr + 1) % 720;
    }

    public void touchHeartbeat() {
        this.lastHeartbeatNanoTime = System.nanoTime();
    }

    public long nanosSinceLastHeartbeat() {
        return System.nanoTime() - this.lastHeartbeatNanoTime;
    }

    public NCConfig getNCConfig() {
        return this.ncConfig;
    }

    public Set<JobId> getActiveJobIds() {
        return this.activeJobIds;
    }

    public NetworkAddress getDataPort() {
        return this.dataPort;
    }

    public NetworkAddress getDatasetPort() {
        return this.datasetPort;
    }

    public NetworkAddress getMessagingPort() {
        return this.messagingPort;
    }

    public NodeCapacity getCapacity() {
        return this.capacity;
    }

    public synchronized ObjectNode toSummaryJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode o = om.createObjectNode();
        JSONUtil.put((ObjectNode)o, (String)"node-id", (String)this.ncConfig.getNodeId());
        JSONUtil.put((ObjectNode)o, (String)"heap-used", (long)this.heapUsedSize[(this.rrdPtr + 720 - 1) % 720]);
        JSONUtil.put((ObjectNode)o, (String)"system-load-average", (double)this.systemLoadAverage[(this.rrdPtr + 720 - 1) % 720]);
        return o;
    }

    public synchronized ObjectNode toDetailedJSON(boolean includeStats, boolean includeConfig) {
        ObjectMapper om = new ObjectMapper();
        ObjectNode o = om.createObjectNode();
        JSONUtil.put((ObjectNode)o, (String)"node-id", (String)this.ncConfig.getNodeId());
        if (includeConfig) {
            JSONUtil.put((ObjectNode)o, (String)"os-name", (String)this.osName);
            JSONUtil.put((ObjectNode)o, (String)"arch", (String)this.arch);
            JSONUtil.put((ObjectNode)o, (String)"os-version", (String)this.osVersion);
            JSONUtil.put((ObjectNode)o, (String)"num-processors", (int)this.nProcessors);
            JSONUtil.put((ObjectNode)o, (String)"vm-name", (String)this.vmName);
            JSONUtil.put((ObjectNode)o, (String)"vm-version", (String)this.vmVersion);
            JSONUtil.put((ObjectNode)o, (String)"vm-vendor", (String)this.vmVendor);
            JSONUtil.put((ObjectNode)o, (String)"classpath", (String[])ConfigurationUtil.toPathElements(this.classpath));
            JSONUtil.put((ObjectNode)o, (String)"library-path", (String[])ConfigurationUtil.toPathElements(this.libraryPath));
            JSONUtil.put((ObjectNode)o, (String)"boot-classpath", (String[])ConfigurationUtil.toPathElements(this.bootClasspath));
            JSONUtil.put((ObjectNode)o, (String)"input-arguments", this.inputArguments);
            JSONUtil.put((ObjectNode)o, (String)"input-arguments", this.inputArguments);
            JSONUtil.put((ObjectNode)o, (String)"system-properties", this.systemProperties);
            JSONUtil.put((ObjectNode)o, (String)"pid", (int)this.pid);
        }
        if (includeStats) {
            o.putPOJO("date", (Object)new Date());
            JSONUtil.put((ObjectNode)o, (String)"rrd-ptr", (int)this.rrdPtr);
            JSONUtil.put((ObjectNode)o, (String)"heartbeat-times", (long[])this.hbTime);
            JSONUtil.put((ObjectNode)o, (String)"heap-init-sizes", (long[])this.heapInitSize);
            JSONUtil.put((ObjectNode)o, (String)"heap-used-sizes", (long[])this.heapUsedSize);
            JSONUtil.put((ObjectNode)o, (String)"heap-committed-sizes", (long[])this.heapCommittedSize);
            JSONUtil.put((ObjectNode)o, (String)"heap-max-sizes", (long[])this.heapMaxSize);
            JSONUtil.put((ObjectNode)o, (String)"nonheap-init-sizes", (long[])this.nonheapInitSize);
            JSONUtil.put((ObjectNode)o, (String)"nonheap-used-sizes", (long[])this.nonheapUsedSize);
            JSONUtil.put((ObjectNode)o, (String)"nonheap-committed-sizes", (long[])this.nonheapCommittedSize);
            JSONUtil.put((ObjectNode)o, (String)"nonheap-max-sizes", (long[])this.nonheapMaxSize);
            JSONUtil.put((ObjectNode)o, (String)"application-memory-budget", (long)this.capacity.getMemoryByteSize());
            JSONUtil.put((ObjectNode)o, (String)"application-cpu-core-budget", (int)this.capacity.getCores());
            JSONUtil.put((ObjectNode)o, (String)"thread-counts", (int[])this.threadCount);
            JSONUtil.put((ObjectNode)o, (String)"peak-thread-counts", (int[])this.peakThreadCount);
            JSONUtil.put((ObjectNode)o, (String)"system-load-averages", (double[])this.systemLoadAverage);
            JSONUtil.put((ObjectNode)o, (String)"gc-names", (String[])this.gcNames);
            JSONUtil.put((ObjectNode)o, (String)"gc-collection-counts", (long[][])this.gcCollectionCounts);
            JSONUtil.put((ObjectNode)o, (String)"gc-collection-times", (long[][])this.gcCollectionTimes);
            JSONUtil.put((ObjectNode)o, (String)"net-payload-bytes-read", (long[])this.netPayloadBytesRead);
            JSONUtil.put((ObjectNode)o, (String)"net-payload-bytes-written", (long[])this.netPayloadBytesWritten);
            JSONUtil.put((ObjectNode)o, (String)"net-signaling-bytes-read", (long[])this.netSignalingBytesRead);
            JSONUtil.put((ObjectNode)o, (String)"net-signaling-bytes-written", (long[])this.netSignalingBytesWritten);
            JSONUtil.put((ObjectNode)o, (String)"dataset-net-payload-bytes-read", (long[])this.datasetNetPayloadBytesRead);
            JSONUtil.put((ObjectNode)o, (String)"dataset-net-payload-bytes-written", (long[])this.datasetNetPayloadBytesWritten);
            JSONUtil.put((ObjectNode)o, (String)"dataset-net-signaling-bytes-read", (long[])this.datasetNetSignalingBytesRead);
            JSONUtil.put((ObjectNode)o, (String)"dataset-net-signaling-bytes-written", (long[])this.datasetNetSignalingBytesWritten);
            JSONUtil.put((ObjectNode)o, (String)"ipc-messages-sent", (long[])this.ipcMessagesSent);
            JSONUtil.put((ObjectNode)o, (String)"ipc-message-bytes-sent", (long[])this.ipcMessageBytesSent);
            JSONUtil.put((ObjectNode)o, (String)"ipc-messages-received", (long[])this.ipcMessagesReceived);
            JSONUtil.put((ObjectNode)o, (String)"ipc-message-bytes-received", (long[])this.ipcMessageBytesReceived);
            JSONUtil.put((ObjectNode)o, (String)"disk-reads", (long[])this.diskReads);
            JSONUtil.put((ObjectNode)o, (String)"disk-writes", (long[])this.diskWrites);
        }
        return o;
    }
}

