/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.ipc.impl;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.hyracks.ipc.impl.HandleState;
import org.apache.hyracks.ipc.impl.IPCHandle;
import org.apache.hyracks.ipc.impl.IPCSystem;
import org.apache.hyracks.ipc.impl.Message;
import org.apache.hyracks.util.NetworkUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IPCConnectionManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int INITIAL_RETRY_DELAY_MILLIS = 100;
    private static final int MAX_RETRY_DELAY_MILLIS = 15000;
    private final IPCSystem system;
    private final NetworkThread networkThread;
    private final ServerSocketChannel serverSocketChannel;
    private final Map<InetSocketAddress, IPCHandle> ipcHandleMap;
    private final List<IPCHandle> pendingConnections;
    private final List<IPCHandle> workingPendingConnections;
    private final List<Message> sendList;
    private final List<Message> workingSendList;
    private final InetSocketAddress address;
    private volatile boolean stopped;

    IPCConnectionManager(IPCSystem system, InetSocketAddress socketAddress) throws IOException {
        this.system = system;
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.socket().setReuseAddress(true);
        this.serverSocketChannel.configureBlocking(false);
        ServerSocket socket = this.serverSocketChannel.socket();
        socket.bind(socketAddress);
        this.address = new InetSocketAddress(socket.getInetAddress(), socket.getLocalPort());
        this.networkThread = new NetworkThread();
        this.networkThread.setPriority(10);
        this.ipcHandleMap = new HashMap<InetSocketAddress, IPCHandle>();
        this.pendingConnections = new ArrayList<IPCHandle>();
        this.workingPendingConnections = new ArrayList<IPCHandle>();
        this.sendList = new ArrayList<Message>();
        this.workingSendList = new ArrayList<Message>();
    }

    InetSocketAddress getAddress() {
        return this.address;
    }

    void start() {
        this.stopped = false;
        this.networkThread.start();
    }

    void stop() {
        this.stopped = true;
        IOUtils.closeQuietly((Closeable)this.serverSocketChannel);
        this.networkThread.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IPCHandle getIPCHandle(InetSocketAddress remoteAddress, int maxRetries) throws IOException, InterruptedException {
        int retries = 0;
        int delay = 100;
        while (true) {
            IPCHandle handle;
            IPCConnectionManager iPCConnectionManager = this;
            synchronized (iPCConnectionManager) {
                handle = this.ipcHandleMap.get(remoteAddress);
                if (handle == null || !handle.isConnected()) {
                    handle = new IPCHandle(this.system, remoteAddress);
                    this.pendingConnections.add(handle);
                    this.networkThread.selector.wakeup();
                }
            }
            if (handle.waitTillConnected()) {
                return handle;
            }
            if (maxRetries >= 0 && retries++ >= maxRetries) break;
            LOGGER.warn("Connection to " + remoteAddress + " failed; retrying" + (maxRetries <= 0 ? "" : " (retry attempt " + retries + " of " + maxRetries + ") after " + delay + "ms"));
            Thread.sleep(delay);
            delay = Math.min(15000, (int)((double)delay * 1.5));
        }
        throw new IOException("Connection failed to " + remoteAddress);
    }

    synchronized void registerHandle(IPCHandle handle) {
        this.ipcHandleMap.put(handle.getRemoteAddress(), handle);
    }

    synchronized void write(Message msg) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Enqueued message: " + msg);
        }
        this.sendList.add(msg);
        this.networkThread.selector.wakeup();
    }

    private synchronized void collectOutstandingWork() {
        if (!this.pendingConnections.isEmpty()) {
            this.moveAll(this.pendingConnections, this.workingPendingConnections);
        }
        if (!this.sendList.isEmpty()) {
            this.moveAll(this.sendList, this.workingSendList);
        }
    }

    private Message createInitialReqMessage(IPCHandle handle) {
        Message msg = new Message(handle);
        msg.setMessageId(this.system.createMessageId());
        msg.setRequestMessageId(-1L);
        msg.setFlag((byte)1);
        msg.setPayload(this.address);
        return msg;
    }

    private Message createInitialAckMessage(IPCHandle handle, Message req) {
        Message msg = new Message(handle);
        msg.setMessageId(this.system.createMessageId());
        msg.setRequestMessageId(req.getMessageId());
        msg.setFlag((byte)2);
        msg.setPayload(null);
        return msg;
    }

    void ack(IPCHandle handle, Message req) {
        this.write(this.createInitialAckMessage(handle, req));
    }

    private <T> void moveAll(List<T> source, List<T> target) {
        int len = source.size();
        for (int i = 0; i < len; ++i) {
            target.add(source.get(i));
        }
        source.clear();
    }

    private class NetworkThread
    extends Thread {
        private final Selector selector;
        private final Set<SocketChannel> openChannels;

        public NetworkThread() {
            super("IPC Network Listener Thread [" + IPCConnectionManager.this.address + "]");
            this.openChannels = new HashSet<SocketChannel>();
            this.setDaemon(true);
            try {
                this.selector = Selector.open();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            finally {
                this.cleanup();
            }
        }

        private void doRun() {
            try {
                IPCConnectionManager.this.serverSocketChannel.register(this.selector, 16);
            }
            catch (ClosedChannelException e) {
                throw new RuntimeException(e);
            }
            BitSet unsentMessagesBitmap = new BitSet();
            ArrayList<Message> tempUnsentMessages = new ArrayList<Message>();
            int failingLoops = 0;
            while (!IPCConnectionManager.this.stopped) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Starting Select");
                    }
                    int n = this.selector.select();
                    IPCConnectionManager.this.collectOutstandingWork();
                    if (!IPCConnectionManager.this.workingPendingConnections.isEmpty()) {
                        for (IPCHandle handle : IPCConnectionManager.this.workingPendingConnections) {
                            SelectionKey cKey;
                            SocketChannel channel = SocketChannel.open();
                            this.register(channel);
                            if (channel.connect(handle.getRemoteAddress())) {
                                cKey = channel.register(this.selector, 1);
                                handle.setState(HandleState.CONNECT_SENT);
                                IPCConnectionManager.this.write(IPCConnectionManager.this.createInitialReqMessage(handle));
                            } else {
                                cKey = channel.register(this.selector, 8);
                            }
                            handle.setKey(cKey);
                            cKey.attach(handle);
                        }
                        IPCConnectionManager.this.workingPendingConnections.clear();
                    }
                    if (!IPCConnectionManager.this.workingSendList.isEmpty()) {
                        unsentMessagesBitmap.clear();
                        int len = IPCConnectionManager.this.workingSendList.size();
                        block8: for (int i = 0; i < len; ++i) {
                            Message msg = (Message)IPCConnectionManager.this.workingSendList.get(i);
                            LOGGER.debug(() -> "Processing send of message: " + msg);
                            IPCHandle handle = msg.getIPCHandle();
                            if (handle.getState() == HandleState.CLOSED) continue;
                            if (!handle.full()) {
                                while (true) {
                                    ByteBuffer buffer = handle.getOutBuffer();
                                    buffer.compact();
                                    boolean success = msg.write(buffer);
                                    buffer.flip();
                                    if (success) {
                                        IPCConnectionManager.this.system.getPerformanceCounters().addMessageSentCount(1L);
                                        SelectionKey key = handle.getKey();
                                        key.interestOps(key.interestOps() | 4);
                                        continue block8;
                                    }
                                    if (buffer.hasRemaining()) break;
                                    handle.resizeOutBuffer();
                                }
                                handle.markFull();
                                unsentMessagesBitmap.set(i);
                                continue;
                            }
                            unsentMessagesBitmap.set(i);
                        }
                        this.copyUnsentMessages(unsentMessagesBitmap, tempUnsentMessages);
                    }
                    if (n > 0) {
                        Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
                        while (i.hasNext()) {
                            IPCHandle handle;
                            SocketChannel channel;
                            SelectionKey key = i.next();
                            i.remove();
                            SelectableChannel sc = key.channel();
                            if (key.isReadable()) {
                                this.read(key);
                                continue;
                            }
                            if (key.isWritable()) {
                                this.write(key);
                                continue;
                            }
                            if (key.isAcceptable()) {
                                assert (sc == IPCConnectionManager.this.serverSocketChannel);
                                channel = IPCConnectionManager.this.serverSocketChannel.accept();
                                this.register(channel);
                                handle = new IPCHandle(IPCConnectionManager.this.system, null);
                                SelectionKey cKey = channel.register(this.selector, 1);
                                handle.setKey(cKey);
                                cKey.attach(handle);
                                handle.setState(HandleState.CONNECT_RECEIVED);
                                continue;
                            }
                            if (!key.isConnectable()) continue;
                            channel = (SocketChannel)sc;
                            handle = (IPCHandle)key.attachment();
                            if (!this.finishConnect(channel)) {
                                handle.setState(HandleState.CONNECT_FAILED);
                                continue;
                            }
                            handle.setState(HandleState.CONNECT_SENT);
                            IPCConnectionManager.this.registerHandle(handle);
                            key.interestOps(1);
                            IPCConnectionManager.this.write(IPCConnectionManager.this.createInitialReqMessage(handle));
                        }
                    }
                    failingLoops = 0;
                }
                catch (Exception e) {
                    int sleepSecs = (int)Math.pow(2.0, Math.min(11, failingLoops++));
                    LOGGER.log(Level.ERROR, "Exception processing message; sleeping " + sleepSecs + " seconds", (Throwable)e);
                    try {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(sleepSecs));
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        private void cleanup() {
            for (Channel channel : this.openChannels) {
                IOUtils.closeQuietly((Closeable)channel);
            }
            this.openChannels.clear();
            IOUtils.closeQuietly((Selector)this.selector);
        }

        private boolean finishConnect(SocketChannel channel) {
            boolean connectFinished = false;
            try {
                connectFinished = channel.finishConnect();
                if (!connectFinished) {
                    LOGGER.log(Level.WARN, "Channel connect did not finish");
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARN, "Exception finishing channel connect", (Throwable)e);
            }
            return connectFinished;
        }

        private void copyUnsentMessages(BitSet unsentMessagesBitmap, List<Message> tempUnsentMessages) {
            assert (tempUnsentMessages.isEmpty());
            int i = unsentMessagesBitmap.nextSetBit(0);
            while (i >= 0) {
                tempUnsentMessages.add((Message)IPCConnectionManager.this.workingSendList.get(i));
                i = unsentMessagesBitmap.nextSetBit(i + 1);
            }
            IPCConnectionManager.this.workingSendList.clear();
            IPCConnectionManager.this.moveAll(tempUnsentMessages, IPCConnectionManager.this.workingSendList);
        }

        private void register(SocketChannel channel) throws IOException {
            this.openChannels.add(channel);
            NetworkUtil.configure((SocketChannel)channel);
            channel.configureBlocking(false);
        }

        private void read(SelectionKey readableKey) {
            SocketChannel channel = (SocketChannel)readableKey.channel();
            IPCHandle handle = (IPCHandle)readableKey.attachment();
            ByteBuffer readBuffer = handle.getInBuffer();
            try {
                int len = channel.read(readBuffer);
                if (len < 0) {
                    this.close(readableKey, channel);
                    return;
                }
                IPCConnectionManager.this.system.getPerformanceCounters().addMessageBytesReceived(len);
                handle.processIncomingMessages();
                if (!readBuffer.hasRemaining()) {
                    handle.resizeInBuffer();
                }
            }
            catch (IOException e) {
                LOGGER.error("TCP read error from {}", (Object)handle.getRemoteAddress(), (Object)e);
                this.close(readableKey, channel);
            }
        }

        private void write(SelectionKey writableKey) {
            SocketChannel channel = (SocketChannel)writableKey.channel();
            IPCHandle handle = (IPCHandle)writableKey.attachment();
            ByteBuffer writeBuffer = handle.getOutBuffer();
            try {
                int len = channel.write(writeBuffer);
                if (len < 0) {
                    this.close(writableKey, channel);
                    return;
                }
                IPCConnectionManager.this.system.getPerformanceCounters().addMessageBytesSent(len);
                if (!writeBuffer.hasRemaining()) {
                    writableKey.interestOps(writableKey.interestOps() & 0xFFFFFFFB);
                }
                if (handle.full()) {
                    handle.clearFull();
                    this.selector.wakeup();
                }
            }
            catch (IOException e) {
                LOGGER.error("TCP write error to {}", (Object)handle.getRemoteAddress(), (Object)e);
                this.close(writableKey, channel);
            }
        }

        private void close(SelectionKey key, SocketChannel sc) {
            key.cancel();
            NetworkUtil.closeQuietly((SocketChannel)sc);
            this.openChannels.remove(sc);
            IPCHandle handle = (IPCHandle)key.attachment();
            handle.close();
        }
    }
}

