/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.clause;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class GroupbyClause
implements Clause {
    private List<GbyVariableExpressionPair> gbyPairList;
    private List<GbyVariableExpressionPair> decorPairList;
    private Map<Expression, VariableExpr> withVarMap;
    private VariableExpr groupVar;
    private List<Pair<Expression, Identifier>> groupFieldList = new ArrayList<Pair<Expression, Identifier>>();
    private boolean hashGroupByHint = false;
    private boolean groupAll = false;

    public GroupbyClause() {
    }

    public GroupbyClause(List<GbyVariableExpressionPair> gbyPairList, List<GbyVariableExpressionPair> decorPairList, Map<Expression, VariableExpr> withVarList, VariableExpr groupVarExpr, List<Pair<Expression, Identifier>> groupFieldList, boolean hashGroupByHint) {
        this(gbyPairList, decorPairList, withVarList, groupVarExpr, groupFieldList, hashGroupByHint, false);
    }

    public GroupbyClause(List<GbyVariableExpressionPair> gbyPairList, List<GbyVariableExpressionPair> decorPairList, Map<Expression, VariableExpr> withVarList, VariableExpr groupVarExpr, List<Pair<Expression, Identifier>> groupFieldList, boolean hashGroupByHint, boolean groupAll) {
        this.gbyPairList = gbyPairList;
        this.decorPairList = decorPairList;
        this.withVarMap = withVarList;
        this.groupVar = groupVarExpr;
        if (groupFieldList != null) {
            this.groupFieldList = groupFieldList;
        }
        this.hashGroupByHint = hashGroupByHint;
        this.groupAll = groupAll;
    }

    public List<GbyVariableExpressionPair> getGbyPairList() {
        return this.gbyPairList;
    }

    public void setGbyPairList(List<GbyVariableExpressionPair> vePairList) {
        this.gbyPairList = vePairList;
    }

    public Map<Expression, VariableExpr> getWithVarMap() {
        return this.withVarMap;
    }

    public void setWithVarMap(Map<Expression, VariableExpr> withVarList) {
        this.withVarMap = withVarList;
    }

    public VariableExpr getGroupVar() {
        return this.groupVar;
    }

    public void setGroupVar(VariableExpr groupVarExpr) {
        this.groupVar = groupVarExpr;
    }

    public List<Pair<Expression, Identifier>> getGroupFieldList() {
        return this.groupFieldList;
    }

    public void setGroupFieldList(List<Pair<Expression, Identifier>> groupFieldList) {
        this.groupFieldList = groupFieldList;
    }

    @Override
    public Clause.ClauseType getClauseType() {
        return Clause.ClauseType.GROUP_BY_CLAUSE;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public void setDecorPairList(List<GbyVariableExpressionPair> decorPairList) {
        this.decorPairList = decorPairList;
    }

    public List<GbyVariableExpressionPair> getDecorPairList() {
        return this.decorPairList;
    }

    public void setHashGroupByHint(boolean hashGroupByHint) {
        this.hashGroupByHint = hashGroupByHint;
    }

    public boolean hasHashGroupByHint() {
        return this.hashGroupByHint;
    }

    public boolean hasDecorList() {
        return this.decorPairList != null && !this.decorPairList.isEmpty();
    }

    public boolean hasWithMap() {
        return this.withVarMap != null && !this.withVarMap.isEmpty();
    }

    public boolean hasGroupVar() {
        return this.groupVar != null;
    }

    public boolean hasGroupFieldList() {
        return this.groupFieldList != null && !this.groupFieldList.isEmpty();
    }

    public boolean isGroupAll() {
        return this.groupAll;
    }

    public int hashCode() {
        return Objects.hash(this.decorPairList, this.gbyPairList, this.groupAll, this.groupFieldList, this.groupVar, this.hashGroupByHint, this.withVarMap);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GroupbyClause)) {
            return false;
        }
        GroupbyClause target = (GroupbyClause)object;
        return Objects.equals(this.decorPairList, target.decorPairList) && Objects.equals(this.gbyPairList, target.gbyPairList) && this.groupAll == target.groupAll && Objects.equals(this.groupFieldList, target.groupFieldList) && Objects.equals(this.groupVar, target.groupVar) && this.hashGroupByHint == target.hashGroupByHint && Objects.equals(this.withVarMap, target.withVarMap);
    }
}

