/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;

public class GroupFrameAccessor
implements IFrameTupleAccessor {
    private final RecordDescriptor recordDescriptor;
    private final int minFrameSize;
    private final FrameTupleAccessor frameTupleAccessor;
    private int lastFrameId;
    private int lastFrameStart;
    private int lastFrameEnd;
    private ByteBuffer buffer;
    private final List<InnerFrameInfo> innerFrameInfos;

    public GroupFrameAccessor(int minFrameSize, RecordDescriptor recordDescriptor) {
        this.minFrameSize = minFrameSize;
        this.recordDescriptor = recordDescriptor;
        this.frameTupleAccessor = new FrameTupleAccessor(recordDescriptor);
        this.innerFrameInfos = new ArrayList<InnerFrameInfo>();
    }

    public int getFieldCount() {
        return this.recordDescriptor.getFieldCount();
    }

    public int getFieldSlotsLength() {
        return this.frameTupleAccessor.getFieldSlotsLength();
    }

    public int getFieldEndOffset(int tupleIndex, int fIdx) {
        return this.frameTupleAccessor.getFieldEndOffset(this.resetSubTupleAccessor(tupleIndex), fIdx);
    }

    public int getFieldStartOffset(int tupleIndex, int fIdx) {
        return this.frameTupleAccessor.getFieldStartOffset(this.resetSubTupleAccessor(tupleIndex), fIdx);
    }

    public int getFieldLength(int tupleIndex, int fIdx) {
        return this.frameTupleAccessor.getFieldLength(this.resetSubTupleAccessor(tupleIndex), fIdx);
    }

    public int getTupleLength(int tupleIndex) {
        return this.frameTupleAccessor.getTupleLength(this.resetSubTupleAccessor(tupleIndex));
    }

    public int getTupleEndOffset(int tupleIndex) {
        return this.frameTupleAccessor.getTupleEndOffset(this.resetSubTupleAccessor(tupleIndex));
    }

    public int getTupleStartOffset(int tupleIndex) {
        return this.frameTupleAccessor.getTupleStartOffset(this.resetSubTupleAccessor(tupleIndex));
    }

    public int getAbsoluteFieldStartOffset(int tupleIndex, int fIdx) {
        return this.frameTupleAccessor.getAbsoluteFieldStartOffset(this.resetSubTupleAccessor(tupleIndex), fIdx);
    }

    public int getTupleCount() {
        return this.innerFrameInfos.size() > 0 ? this.innerFrameInfos.get((int)(this.innerFrameInfos.size() - 1)).tupleCount : 0;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void reset(ByteBuffer buffer) {
        this.buffer = buffer;
        this.lastFrameId = -1;
        this.lastFrameStart = -1;
        this.lastFrameEnd = -1;
        this.parseGroupedBuffer(0, buffer.limit());
    }

    private void parseGroupedBuffer(int start, int stop) {
        int i;
        int unitSize;
        this.innerFrameInfos.clear();
        for (i = start; i < stop && (unitSize = FrameHelper.deserializeNumOfMinFrame((ByteBuffer)this.buffer, (int)i) * this.minFrameSize) != 0 && i + unitSize <= stop; i += unitSize) {
            this.frameTupleAccessor.reset(this.buffer, i, unitSize);
            this.innerFrameInfos.add(new InnerFrameInfo(i, unitSize, this.getTupleCount() + this.frameTupleAccessor.getTupleCount()));
        }
        this.buffer.position(i);
    }

    private int resetSubTupleAccessor(int tupleIndex) {
        assert (tupleIndex < this.getTupleCount());
        if (tupleIndex >= this.lastFrameStart && tupleIndex < this.lastFrameEnd) {
            return tupleIndex - this.lastFrameStart;
        }
        int subFrameId = Collections.binarySearch(this.innerFrameInfos, tupleIndex);
        subFrameId = subFrameId >= 0 ? ++subFrameId : -subFrameId - 1;
        this.frameTupleAccessor.reset(this.buffer, this.innerFrameInfos.get((int)subFrameId).start, this.innerFrameInfos.get((int)subFrameId).length);
        this.lastFrameId = subFrameId;
        this.lastFrameStart = this.lastFrameId > 0 ? this.innerFrameInfos.get((int)(this.lastFrameId - 1)).tupleCount : 0;
        this.lastFrameEnd = this.innerFrameInfos.get((int)this.lastFrameId).tupleCount;
        return tupleIndex - this.lastFrameStart;
    }

    private class InnerFrameInfo
    implements Comparable<Integer> {
        int start;
        int length;
        int tupleCount;

        InnerFrameInfo(int start, int length, int tupleCount) {
            this.start = start;
            this.length = length;
            this.tupleCount = tupleCount;
        }

        @Override
        public int compareTo(Integer o) {
            return -o.compareTo(this.tupleCount);
        }
    }
}

