/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IActivityGraphBuilder;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.dataflow.common.io.GeneratedRunFileReader;
import org.apache.hyracks.dataflow.std.base.AbstractActivityNode;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractStateObject;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import org.apache.hyracks.dataflow.std.sort.AbstractExternalSortRunMerger;
import org.apache.hyracks.dataflow.std.sort.AbstractSortRunGenerator;
import org.apache.hyracks.dataflow.std.sort.ISorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractSorterOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    protected static final int SORT_ACTIVITY_ID = 0;
    protected static final int MERGE_ACTIVITY_ID = 1;
    protected final int[] sortFields;
    protected final INormalizedKeyComputerFactory[] keyNormalizerFactories;
    protected final IBinaryComparatorFactory[] comparatorFactories;
    protected final int framesLimit;

    public AbstractSorterOperatorDescriptor(IOperatorDescriptorRegistry spec, int framesLimit, int[] sortFields, INormalizedKeyComputerFactory[] keyNormalizerFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) {
        super(spec, 1, 1);
        this.framesLimit = framesLimit;
        this.sortFields = sortFields;
        this.keyNormalizerFactories = keyNormalizerFactories;
        this.comparatorFactories = comparatorFactories;
        this.outRecDescs[0] = recordDescriptor;
    }

    public abstract SortActivity getSortActivity(ActivityId var1);

    public abstract MergeActivity getMergeActivity(ActivityId var1);

    public void contributeActivities(IActivityGraphBuilder builder) {
        SortActivity sa = this.getSortActivity(new ActivityId(this.odId, 0));
        MergeActivity ma = this.getMergeActivity(new ActivityId(this.odId, 1));
        builder.addActivity((IOperatorDescriptor)this, (IActivity)sa);
        builder.addSourceEdge(0, (IActivity)sa, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)ma);
        builder.addTargetEdge(0, (IActivity)ma, 0);
        builder.addBlockingEdge((IActivity)sa, (IActivity)ma);
    }

    protected abstract class MergeActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public MergeActivity(ActivityId id) {
            super(id);
        }

        protected abstract AbstractExternalSortRunMerger getSortRunMerger(IHyracksTaskContext var1, IRecordDescriptorProvider var2, IFrameWriter var3, ISorter var4, List<GeneratedRunFileReader> var5, IBinaryComparator[] var6, INormalizedKeyComputer var7, int var8);

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, final IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            AbstractUnaryOutputSourceOperatorNodePushable op = new AbstractUnaryOutputSourceOperatorNodePushable(){

                @Override
                public void initialize() throws HyracksDataException {
                    SortTaskState state = (SortTaskState)ctx.getStateObject((Object)new TaskId(new ActivityId(AbstractSorterOperatorDescriptor.this.getOperatorId(), 0), partition));
                    List<GeneratedRunFileReader> runs = state.generatedRunFileReaders;
                    ISorter sorter = state.sorter;
                    IBinaryComparator[] comparators = new IBinaryComparator[AbstractSorterOperatorDescriptor.this.comparatorFactories.length];
                    for (int i = 0; i < AbstractSorterOperatorDescriptor.this.comparatorFactories.length; ++i) {
                        comparators[i] = AbstractSorterOperatorDescriptor.this.comparatorFactories[i].createBinaryComparator();
                    }
                    INormalizedKeyComputer nmkComputer = AbstractSorterOperatorDescriptor.this.keyNormalizerFactories == null ? null : AbstractSorterOperatorDescriptor.this.keyNormalizerFactories[0].createNormalizedKeyComputer();
                    AbstractExternalSortRunMerger merger = MergeActivity.this.getSortRunMerger(ctx, recordDescProvider, this.writer, sorter, runs, comparators, nmkComputer, AbstractSorterOperatorDescriptor.this.framesLimit);
                    merger.process();
                }
            };
            return op;
        }
    }

    protected abstract class SortActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public SortActivity(ActivityId id) {
            super(id);
        }

        protected abstract AbstractSortRunGenerator getRunGenerator(IHyracksTaskContext var1, IRecordDescriptorProvider var2) throws HyracksDataException;

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, final IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            AbstractUnaryInputSinkOperatorNodePushable op = new AbstractUnaryInputSinkOperatorNodePushable(){
                private AbstractSortRunGenerator runGen;

                public void open() throws HyracksDataException {
                    this.runGen = SortActivity.this.getRunGenerator(ctx, recordDescProvider);
                    this.runGen.open();
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.runGen.nextFrame(buffer);
                }

                public void close() throws HyracksDataException {
                    SortTaskState state = new SortTaskState(ctx.getJobletContext().getJobId(), new TaskId(SortActivity.this.getActivityId(), partition));
                    this.runGen.close();
                    state.generatedRunFileReaders = this.runGen.getRuns();
                    state.sorter = this.runGen.getSorter();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("InitialNumberOfRuns:" + this.runGen.getRuns().size());
                    }
                    ctx.setStateObject((IStateObject)state);
                }

                public void fail() throws HyracksDataException {
                    this.runGen.fail();
                }
            };
            return op;
        }
    }

    public static class SortTaskState
    extends AbstractStateObject {
        public List<GeneratedRunFileReader> generatedRunFileReaders;
        public ISorter sorter;

        public SortTaskState(JobId jobId, TaskId taskId) {
            super(jobId, taskId);
        }
    }
}

