/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.group.preclustered;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppenderWrapper;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.std.group.AggregateState;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptor;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;

public class PreclusteredGroupWriter
implements IFrameWriter {
    private final int[] groupFields;
    private final IBinaryComparator[] comparators;
    private final IAggregatorDescriptor aggregator;
    private final AggregateState aggregateState;
    private final IFrame copyFrame;
    private final FrameTupleAccessor inFrameAccessor;
    private final FrameTupleAccessor copyFrameAccessor;
    private final FrameTupleAppenderWrapper appenderWrapper;
    private final ArrayTupleBuilder tupleBuilder;
    private final boolean groupAll;
    private final boolean outputPartial;
    private boolean first;
    private boolean isFailed = false;
    private final long memoryLimit;

    public PreclusteredGroupWriter(IHyracksTaskContext ctx, int[] groupFields, IBinaryComparator[] comparators, IAggregatorDescriptorFactory aggregatorFactory, RecordDescriptor inRecordDesc, RecordDescriptor outRecordDesc, IFrameWriter writer) throws HyracksDataException {
        this(ctx, groupFields, comparators, aggregatorFactory, inRecordDesc, outRecordDesc, writer, false, false, -1);
    }

    public PreclusteredGroupWriter(IHyracksTaskContext ctx, int[] groupFields, IBinaryComparator[] comparators, IAggregatorDescriptorFactory aggregatorFactory, RecordDescriptor inRecordDesc, RecordDescriptor outRecordDesc, IFrameWriter writer, boolean outputPartial) throws HyracksDataException {
        this(ctx, groupFields, comparators, aggregatorFactory, inRecordDesc, outRecordDesc, writer, outputPartial, false, -1);
    }

    public PreclusteredGroupWriter(IHyracksTaskContext ctx, int[] groupFields, IBinaryComparator[] comparators, IAggregatorDescriptorFactory aggregatorFactory, RecordDescriptor inRecordDesc, RecordDescriptor outRecordDesc, IFrameWriter writer, boolean outputPartial, boolean groupAll, int framesLimit) throws HyracksDataException {
        this.groupFields = groupFields;
        this.comparators = comparators;
        if (framesLimit >= 0 && framesLimit <= 2) {
            throw HyracksDataException.create((int)90, (Serializable[])new Serializable[]{"GROUP BY", Long.toString((long)framesLimit * (long)ctx.getInitialFrameSize()), Long.toString(2L * (long)ctx.getInitialFrameSize())});
        }
        this.memoryLimit = framesLimit <= 0 ? -1L : (long)(framesLimit - 2) * (long)ctx.getInitialFrameSize();
        this.aggregator = aggregatorFactory.createAggregator(ctx, inRecordDesc, outRecordDesc, groupFields, groupFields, writer, this.memoryLimit);
        this.aggregateState = this.aggregator.createAggregateStates();
        this.copyFrame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        this.inFrameAccessor = new FrameTupleAccessor(inRecordDesc);
        this.copyFrameAccessor = new FrameTupleAccessor(inRecordDesc);
        this.copyFrameAccessor.reset(this.copyFrame.getBuffer());
        VSizeFrame outFrame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        FrameTupleAppender appender = new FrameTupleAppender();
        appender.reset((IFrame)outFrame, true);
        this.appenderWrapper = new FrameTupleAppenderWrapper((IFrameTupleAppender)appender, writer);
        this.tupleBuilder = new ArrayTupleBuilder(outRecordDesc.getFields().length);
        this.outputPartial = outputPartial;
        this.groupAll = groupAll;
    }

    public void open() throws HyracksDataException {
        this.appenderWrapper.open();
        this.first = true;
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.inFrameAccessor.reset(buffer);
        int nTuples = this.inFrameAccessor.getTupleCount();
        if (nTuples != 0) {
            for (int i = 0; i < nTuples; ++i) {
                if (this.first) {
                    this.tupleBuilder.reset();
                    for (int j = 0; j < this.groupFields.length; ++j) {
                        this.tupleBuilder.addField((IFrameTupleAccessor)this.inFrameAccessor, i, this.groupFields[j]);
                    }
                    this.aggregator.init(this.tupleBuilder, (IFrameTupleAccessor)this.inFrameAccessor, i, this.aggregateState);
                    this.first = false;
                    continue;
                }
                if (i == 0) {
                    this.switchGroupIfRequired(this.copyFrameAccessor, this.copyFrameAccessor.getTupleCount() - 1, this.inFrameAccessor, i);
                    continue;
                }
                this.switchGroupIfRequired(this.inFrameAccessor, i - 1, this.inFrameAccessor, i);
            }
            this.copyFrame.ensureFrameSize(buffer.capacity());
            FrameUtils.copyAndFlip((ByteBuffer)buffer, (ByteBuffer)this.copyFrame.getBuffer());
            this.copyFrameAccessor.reset(this.copyFrame.getBuffer());
        }
    }

    private void switchGroupIfRequired(FrameTupleAccessor prevTupleAccessor, int prevTupleIndex, FrameTupleAccessor currTupleAccessor, int currTupleIndex) throws HyracksDataException {
        if (!this.sameGroup(prevTupleAccessor, prevTupleIndex, currTupleAccessor, currTupleIndex)) {
            this.writeOutput(prevTupleAccessor, prevTupleIndex);
            this.tupleBuilder.reset();
            for (int j = 0; j < this.groupFields.length; ++j) {
                this.tupleBuilder.addField((IFrameTupleAccessor)currTupleAccessor, currTupleIndex, this.groupFields[j]);
            }
            this.aggregator.init(this.tupleBuilder, (IFrameTupleAccessor)currTupleAccessor, currTupleIndex, this.aggregateState);
        } else {
            this.aggregator.aggregate((IFrameTupleAccessor)currTupleAccessor, currTupleIndex, null, 0, this.aggregateState);
        }
    }

    private void writeOutput(FrameTupleAccessor lastTupleAccessor, int lastTupleIndex) throws HyracksDataException {
        boolean hasOutput;
        this.tupleBuilder.reset();
        for (int j = 0; j < this.groupFields.length; ++j) {
            this.tupleBuilder.addField((IFrameTupleAccessor)lastTupleAccessor, lastTupleIndex, this.groupFields[j]);
        }
        boolean bl = hasOutput = this.outputPartial ? this.aggregator.outputPartialResult(this.tupleBuilder, (IFrameTupleAccessor)lastTupleAccessor, lastTupleIndex, this.aggregateState) : this.aggregator.outputFinalResult(this.tupleBuilder, (IFrameTupleAccessor)lastTupleAccessor, lastTupleIndex, this.aggregateState);
        if (hasOutput) {
            this.appenderWrapper.appendSkipEmptyField(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray(), 0, this.tupleBuilder.getSize());
        }
    }

    private boolean sameGroup(FrameTupleAccessor a1, int t1Idx, FrameTupleAccessor a2, int t2Idx) throws HyracksDataException {
        for (int i = 0; i < this.comparators.length; ++i) {
            int fIdx = this.groupFields[i];
            int s1 = a1.getAbsoluteFieldStartOffset(t1Idx, fIdx);
            int l1 = a1.getFieldLength(t1Idx, fIdx);
            int s2 = a2.getAbsoluteFieldStartOffset(t2Idx, fIdx);
            int l2 = a2.getFieldLength(t2Idx, fIdx);
            if (this.comparators[i].compare(a1.getBuffer().array(), s1, l1, a2.getBuffer().array(), s2, l2) == 0) continue;
            return false;
        }
        return true;
    }

    public void fail() throws HyracksDataException {
        this.isFailed = true;
        this.appenderWrapper.fail();
    }

    public void close() throws HyracksDataException {
        try {
            if (!(this.isFailed || this.first && !this.groupAll)) {
                this.writeOutput(this.copyFrameAccessor, this.copyFrameAccessor.getTupleCount() - 1);
                this.appenderWrapper.write();
            }
            this.aggregator.close();
            this.aggregateState.close();
        }
        catch (Exception e) {
            this.appenderWrapper.fail();
            throw e;
        }
        finally {
            this.appenderWrapper.close();
        }
    }
}

